/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.block.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepbus.block.entity.ConfigProvider;
import com.neep.neepbus.screen.MouthScreenHandler;
import com.neep.neepbus.util.NeepBusConfig;
import com.neep.neepbus.util.SimpleEntry;
import com.neep.neepbus.util.WritePort;
import com.neep.neepbus.util.message.DataVariant;
import com.neep.neepmeat.client.sound.NEEPSpeakAudioStream;
import com.neep.neepmeat.network.NEEPSpeakSayS2C;
import com.neep.neepspeak.NEEPSpeakException;
import com.neep.neepspeak.PhonemeList;
import com.neep.neepspeak.parser.RuleParser;
import com.neep.neepspeak.phoneme.PhonemeSet;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class MouthBlockEntity
extends SyncableBlockEntity
implements ConfigProvider {
    private String message = "";
    private boolean autoSay = true;
    private boolean phonetic = false;
    private int radius = 10;
    private long lastTrigger;
    private final WritePort setMessage = this::setMessage;
    private final WritePort trigger = dataVariant -> this.trigger();
    private final WritePort setPhonetic = this::setPhonetic;
    private final NeepBusConfig config = NeepBusConfig.builder(this::sync).input(new SimpleEntry("Set message"), this.setMessage).input(new SimpleEntry("Set phonetic"), this.setPhonetic).input(new SimpleEntry("Say"), this.trigger).applyChanges(this).build();
    private String error = "";

    private void setPhonetic(DataVariant v) {
        this.phonetic = v.boolValue();
        this.method_5431();
    }

    public MouthBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public static PhonemeList parse(String msg, boolean phonetic) throws NEEPSpeakException {
        return phonetic ? new PhonemeList(RuleParser.parseSamPhonetic((String)msg, (PhonemeSet)PhonemeSet.NORMAL)) : NEEPSpeakAudioStream.PHONEMISER.process(msg);
    }

    private void setMessage(DataVariant dataVariant) {
        this.message = dataVariant.stringValue();
        this.sync();
        if (this.autoSay) {
            this.trigger();
        }
    }

    public void trigger() {
        if (this.field_11863.method_8510() - this.lastTrigger < 10L) {
            return;
        }
        this.lastTrigger = this.field_11863.method_8510();
        this.error = "";
        try {
            MouthBlockEntity.parse(this.message, this.phonetic);
            PlayerLookup.around((class_3218)((class_3218)this.field_11863), (class_2382)this.field_11867, (double)this.radius).forEach(p -> NEEPSpeakSayS2C.CHANNEL.emitter((class_1657)p).apply(this.message, this.field_11867, this.phonetic));
        }
        catch (NEEPSpeakException e) {
            this.error = e.getMessage();
        }
    }

    public void setValues(String message, boolean autoSay, boolean phonetic, int radius) {
        this.message = message.substring(0, Math.min(1000, message.length()));
        this.autoSay = autoSay;
        this.phonetic = phonetic;
        this.radius = Math.min(radius, 50);
        this.sync();
    }

    @Override
    public NeepBusConfig getConfig() {
        return this.config;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("config", (class_2520)this.config.writeNbt(new class_2487()));
        nbt.method_10582("message", this.message);
        nbt.method_10556("auto_say", this.autoSay);
        nbt.method_10556("phonetic", this.phonetic);
        nbt.method_10569("radius", this.radius);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.config.readNbt(nbt.method_10562("config"));
        this.message = nbt.method_10558("message");
        this.autoSay = nbt.method_10577("auto_say");
        this.phonetic = nbt.method_10577("phonetic");
        this.radius = nbt.method_10550("radius");
    }

    public MouthScreenHandler.Values getValues() {
        return new MouthScreenHandler.Values(this.message, this.autoSay, this.phonetic, this.radius);
    }

    public String getError() {
        return this.error;
    }
}

