/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.block.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepbus.block.entity.ConfigProvider;
import com.neep.neepbus.part.Slider;
import com.neep.neepbus.util.CachingSender;
import com.neep.neepbus.util.DirectReadPort;
import com.neep.neepbus.util.NeepBusConfig;
import com.neep.neepbus.util.SimpleEntry;
import com.neep.neepbus.util.message.DataVariant;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class SliderBlockEntity
extends SyncableBlockEntity
implements Slider,
ConfigProvider {
    private final CachingSender sender = new CachingSender(() -> ((SliderBlockEntity)this).method_10997(), this.method_11016());
    private final DirectReadPort outputPort = new DirectReadPort(new SimpleEntry("Output"), () -> DataVariant.of(this.getValue()), this.sender::send);
    private final NeepBusConfig config = NeepBusConfig.builder(this::sync).output(this.outputPort.entry(), this.outputPort).applyChanges(this).build();
    private float value = 0.0f;
    private float minValue = 0.0f;
    private float maxValue = 256.0f;
    private float interval = 16.0f;

    public SliderBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public float getValue() {
        return this.value;
    }

    @Override
    public float getMinValue() {
        return this.minValue;
    }

    @Override
    public float getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void setValues(float value, float minValue, float maxValue) {
        this.value = class_3532.method_15363((float)value, (float)minValue, (float)maxValue);
        this.minValue = Math.min(minValue, maxValue);
        this.maxValue = Math.max(maxValue, minValue);
        this.sync();
    }

    @Override
    public float getInterval() {
        return this.interval;
    }

    @Override
    public void setInterval(float interval) {
        this.interval = class_3532.method_15363((float)interval, (float)0.001f, (float)(this.maxValue - this.minValue));
        this.sync();
    }

    public void updateNetwork() {
        this.sender.invalidate();
    }

    @Override
    public NeepBusConfig getConfig() {
        return this.config;
    }

    @Override
    public void increment(double amount, boolean large) {
        float increment = Math.signum((float)amount) * Math.max(large ? this.interval : this.interval / 10.0f, 0.001f);
        this.value = class_3532.method_15363((float)(this.value + increment), (float)this.minValue, (float)this.maxValue);
        this.outputPort.send();
        this.sync();
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10548("value", this.value);
        nbt.method_10548("min_value", this.minValue);
        nbt.method_10548("max_value", this.maxValue);
        nbt.method_10548("divisions", this.interval);
        nbt.method_10566("config", (class_2520)this.config.writeNbt(new class_2487()));
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.value = nbt.method_10583("value");
        this.minValue = nbt.method_10583("min_value");
        this.maxValue = nbt.method_10583("max_value");
        this.interval = nbt.method_10583("divisions");
        this.config.readNbt(nbt.method_10562("config"));
    }

    public void invalidate() {
        this.sender.invalidate();
    }
}

