/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.input;

import com.neep.meatlib.api.network.ChannelFormat;
import com.neep.meatlib.api.network.ParamCodec;
import com.neep.meatlib.api.network.ParamCodecs;
import com.neep.meatlib.network.GlobalChannelManager;
import com.neep.neepbus.input.InputInterceptor;
import com.neep.neepbus.input.InputInterceptorPlayer;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class InputInterceptors {
    public static final GlobalChannelManager<ApplyEvent> EVENT = GlobalChannelManager.create(new class_2960("neepmeat", "neepbus/input_event"), ChannelFormat.builder(ApplyEvent.class).param(ParamCodec.BOOLEAN).param(ParamCodec.INT).param(InputInterceptor.Movement.PARAM_CODEC).build());
    public static final GlobalChannelManager<Activate> ACTIVATE = GlobalChannelManager.create(new class_2960("neepmeat", "neepbus/activate_input_interceptor"), ChannelFormat.builder(Activate.class).param(ParamCodec.BOOLEAN).param(ParamCodec.ofNullable(ParamCodecs.IDENTIFIER)).build());

    public static void activate(class_1657 player, InputInterceptor interceptor) {
        InputInterceptorPlayer player1 = (InputInterceptorPlayer)player;
        InputInterceptor prev = player1.neepmeat$getInterceptor();
        if (prev != null) {
            prev.close(player);
        }
        player1.neepmeat$etInterceptor(interceptor);
        interceptor.open(player);
        ACTIVATE.emitter(player).apply(true, interceptor.handlerId());
    }

    public static void deactivate(class_1657 player) {
        InputInterceptorPlayer player1 = (InputInterceptorPlayer)player;
        InputInterceptor prev = player1.neepmeat$getInterceptor();
        if (prev != null) {
            prev.close(player);
        }
        player1.neepmeat$etInterceptor(null);
        ACTIVATE.emitter(player).apply(false, null);
    }

    public static void init() {
        EVENT.receiverHandler(EnvType.SERVER, (player, buf, responseSender) -> (action, name, movement) -> {
            InputInterceptor interceptor = ((InputInterceptorPlayer)player).neepmeat$getInterceptor();
            if (interceptor != null) {
                if (movement != null) {
                    interceptor.movementInput(player, action, movement);
                }
                interceptor.input(player, action, name);
            }
        });
        ACTIVATE.receiverHandler(EnvType.SERVER, (player, buf, responseSender) -> (active, id) -> {
            if (!active) {
                InputInterceptors.deactivate(player);
            }
        });
    }

    public static boolean isActive(class_1657 player) {
        return ((InputInterceptorPlayer)player).neepmeat$getInterceptor() != null;
    }

    public static interface Activate {
        public void apply(boolean var1, @Nullable class_2960 var2);
    }

    public static interface ApplyEvent {
        public void apply(boolean var1, int var2, @Nullable InputInterceptor.Movement var3);
    }
}

