/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.util;

import com.neep.neepbus.block.NeepBusProvider;
import com.neep.neepbus.util.NeepBusPort;
import com.neep.neepbus.util.ReadPort;
import com.neep.neepbus.util.WritePort;
import com.neep.neepbus.util.message.DataVariant;
import com.neep.neepmeat.transport.api.pipe.DataCable;
import com.neep.neepmeat.util.BFSGroupFinder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class CachingSender {
    private final Supplier<class_1937> world;
    private final class_2338 pos;
    private final Map<String, Set<WritePort>> writePortCache = new HashMap<String, Set<WritePort>>();
    private final Map<String, Set<ReadPort>> readPortCache = new HashMap<String, Set<ReadPort>>();

    public CachingSender(Supplier<class_1937> world, class_2338 pos) {
        this.world = world;
        this.pos = pos;
    }

    public void send(String address, DataVariant data) {
        @Nullable Set<WritePort> cached = this.writePortCache.get(address);
        if (cached == null) {
            Finder finder = new Finder(address, false);
            finder.queueBlock(this.pos);
            finder.loop(200);
            cached = new HashSet(finder.getResult().values());
            this.writePortCache.put(address, cached);
        }
        for (WritePort port : cached) {
            port.write(data);
        }
    }

    public DataVariant read(String address) {
        @Nullable Set<ReadPort> cached = this.readPortCache.get(address);
        if (cached == null) {
            Finder finder = new Finder(address, true);
            finder.queueBlock(this.pos);
            finder.loop(200);
            cached = new HashSet(finder.getResult().values());
            this.readPortCache.put(address, cached);
        }
        if (!cached.isEmpty()) {
            return cached.iterator().next().read();
        }
        return DataVariant.NULL;
    }

    public void invalidate() {
        this.writePortCache.clear();
        this.readPortCache.clear();
    }

    private class Finder<T extends NeepBusPort>
    extends BFSGroupFinder<T> {
        private final String address;
        private final boolean read;
        private boolean isOrigin = true;

        public Finder(String address, boolean read) {
            this.address = address;
            this.read = read;
        }

        @Override
        public void queueBlock(class_2338 pos) {
            this.posQueue.add(pos);
            this.visited.add(pos.method_10063());
        }

        @Override
        protected BFSGroupFinder.State processPos(class_2338 pos) {
            class_1937 world = CachingSender.this.world.get();
            class_2680 currentState = world.method_8320(pos);
            class_2338.class_2339 mutable = pos.method_25503();
            for (class_2350 direction : class_2350.values()) {
                NeepBusPort port;
                class_2680 offsetState;
                DataCable dataCable;
                class_2248 class_22482;
                mutable.method_25505((class_2382)pos, direction);
                if (this.visited.contains(mutable.method_10063()) || !((class_22482 = currentState.method_26204()) instanceof DataCable) || !(dataCable = (DataCable)class_22482).isConnected(world, (class_2338)mutable, currentState, direction, this.isOrigin) || (offsetState = world.method_8320((class_2338)mutable)).method_26215()) continue;
                boolean checkAdjacent = dataCable.checkAdjacentConnection();
                class_2248 class_22483 = offsetState.method_26204();
                if (class_22483 instanceof DataCable) {
                    DataCable offset = (DataCable)class_22483;
                    if (!checkAdjacent || offset.isConnected(world, (class_2338)mutable, offsetState, direction.method_10153(), false)) {
                        this.visited.add(mutable.method_10063());
                        this.queueBlock(mutable.method_10062());
                    }
                }
                if (!((class_22483 = offsetState.method_26204()) instanceof NeepBusProvider)) continue;
                NeepBusProvider provider = (NeepBusProvider)class_22483;
                NeepBusPort neepBusPort = port = this.read ? (NeepBusPort)provider.getPorts(world, (class_2338)mutable, offsetState, direction.method_10153()).readMap().get(this.address) : (NeepBusPort)provider.getPorts(world, (class_2338)mutable, offsetState, direction.method_10153()).writeMap().get(this.address);
                if (port == null) continue;
                this.addResult((class_2338)mutable, port);
                this.visited.add(mutable.method_10063());
            }
            this.isOrigin = false;
            return BFSGroupFinder.State.CONTINUE;
        }
    }
}

