/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.util;

import com.neep.neepbus.util.ConfigDelegate;
import com.neep.neepbus.util.ConfigEntry;
import com.neep.neepbus.util.NeepBusConfig;
import com.neep.neepbus.util.NeepBusUtil;
import com.neep.neepbus.util.PortMap;
import com.neep.neepbus.util.ReadPort;
import com.neep.neepbus.util.SimpleReadPort;
import com.neep.neepbus.util.WritePort;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;

public class NeepBusConfigImpl
implements NeepBusConfig {
    @Nullable
    private PortMap portMap = null;
    private final List<InputEntry> inputs;
    private final List<OutputEntry> outputs;
    private final List<WritePort> writePorts;
    private final List<ReadPort> readPorts;
    private final Runnable onOutputChanged;
    private final Runnable markDirty;
    private final Runnable applyChanges;
    private final List<ConfigDelegate> delegates = new ObjectArrayList();

    public NeepBusConfigImpl(List<ConfigEntry> inputs, List<ConfigEntry> outputs, List<WritePort> writePorts, List<ReadPort> readPorts, Runnable onOutputsChanged, Runnable markDirty, Runnable applyChanges) {
        this.inputs = inputs.stream().map(x$0 -> new InputEntry((ConfigEntry)x$0)).toList();
        this.outputs = outputs.stream().map(x$0 -> new OutputEntry((ConfigEntry)x$0)).toList();
        this.writePorts = writePorts;
        this.readPorts = readPorts;
        this.onOutputChanged = onOutputsChanged;
        this.markDirty = markDirty;
        this.applyChanges = applyChanges;
    }

    @Override
    public List<? extends ConfigEntry> getInputs() {
        return this.inputs;
    }

    @Override
    public List<? extends ConfigEntry> getOutputs() {
        return this.outputs;
    }

    @Override
    public void applyChanges() {
        this.applyChanges.run();
    }

    @Override
    public PortMap getPorts() {
        if (this.portMap == null) {
            this.portMap = PortMap.arrayMap((String[])this.inputs.stream().map(ConfigEntry::getAddress).toArray(String[]::new), this.writePorts.toArray(new WritePort[0]), (String[])this.outputs.stream().map(ConfigEntry::getAddress).toArray(String[]::new), this.readPorts.toArray(new ReadPort[0]));
        }
        return this.portMap;
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        class_2499 inputs = new class_2499();
        for (InputEntry input : this.inputs) {
            class_2487 entry = new class_2487();
            entry.method_10582("address", input.getAddress());
            inputs.add((Object)entry);
        }
        nbt.method_10566("inputs", (class_2520)inputs);
        class_2499 outputs = new class_2499();
        for (OutputEntry output : this.outputs) {
            class_2487 entry = new class_2487();
            entry.method_10582("address", output.getAddress());
            outputs.add((Object)entry);
        }
        nbt.method_10566("outputs", (class_2520)outputs);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        class_2499 inputs = nbt.method_10554("inputs", 10);
        for (int i = 0; i < Math.min(this.inputs.size(), inputs.size()); ++i) {
            class_2487 entry = inputs.method_10602(i);
            this.inputs.get((int)i).entry.setAddress(entry.method_10558("address"));
        }
        class_2499 outputs = nbt.method_10554("outputs", 10);
        for (int i = 0; i < Math.min(this.outputs.size(), outputs.size()); ++i) {
            class_2487 entry = outputs.method_10602(i);
            this.outputs.get((int)i).entry.setAddress(entry.method_10558("address"));
        }
    }

    public ConfigDelegate delegate(int port) {
        ConfigDelegate delegate = new ConfigDelegate(this, port);
        this.delegates.add(delegate);
        return delegate;
    }

    private void invalidate() {
        this.portMap = null;
        for (ConfigDelegate delegate : this.delegates) {
            delegate.invalidate();
        }
    }

    public boolean hasOutput(String address) {
        return this.outputs.stream().anyMatch(e -> e.getAddress().equals(address));
    }

    private class InputEntry
    implements ConfigEntry {
        private final ConfigEntry entry;

        private InputEntry(ConfigEntry entry) {
            this.entry = entry;
        }

        @Override
        public String getName() {
            return this.entry.getName();
        }

        @Override
        public String getAddress() {
            return this.entry.getAddress();
        }

        @Override
        public void setAddress(String address) {
            this.entry.setAddress(address);
            NeepBusConfigImpl.this.invalidate();
            NeepBusConfigImpl.this.markDirty.run();
        }
    }

    private class OutputEntry
    implements ConfigEntry {
        private final ConfigEntry entry;

        private OutputEntry(ConfigEntry entry) {
            this.entry = entry;
        }

        @Override
        public String getName() {
            return this.entry.getName();
        }

        @Override
        public String getAddress() {
            return this.entry.getAddress();
        }

        @Override
        public void setAddress(String address) {
            this.entry.setAddress(address);
            NeepBusConfigImpl.this.onOutputChanged.run();
            NeepBusConfigImpl.this.invalidate();
            NeepBusConfigImpl.this.markDirty.run();
        }
    }

    public static class Builder {
        protected final Runnable markDirty;
        protected List<ConfigEntry> inputs = new ObjectArrayList();
        protected List<ConfigEntry> outputs = new ObjectArrayList();
        protected List<WritePort> writePorts = new ObjectArrayList();
        protected List<ReadPort> readPorts = new ObjectArrayList();
        protected Runnable onOutputsChanged = () -> {};
        protected Runnable applyChanges = () -> {};

        public Builder(Runnable markDirty) {
            this.markDirty = markDirty;
        }

        public NeepBusConfigImpl build() {
            return new NeepBusConfigImpl(this.inputs, this.outputs, this.writePorts, this.readPorts, this.onOutputsChanged, this.markDirty, this.applyChanges);
        }

        public Builder inputs(List<ConfigEntry> inputs, List<WritePort> inputPorts) {
            this.inputs = inputs;
            this.writePorts = inputPorts;
            return this;
        }

        public Builder input(ConfigEntry input, WritePort inputPort) {
            this.inputs.add(input);
            this.writePorts.add(inputPort);
            return this;
        }

        public Builder outputs(List<ConfigEntry> outputs, List<ReadPort> readPorts) {
            this.outputs = outputs;
            this.readPorts = readPorts;
            return this;
        }

        public Builder outputs(SimpleReadPort ... ports) {
            for (SimpleReadPort p : ports) {
                this.readPorts.add(p);
                this.outputs.add(p.entry());
            }
            return this;
        }

        public Builder output(ConfigEntry output, ReadPort readPort) {
            this.readPorts.add(readPort);
            this.outputs.add(output);
            return this;
        }

        public Builder onOutputsChanged(Runnable changed) {
            this.onOutputsChanged = changed;
            return this;
        }

        public Builder applyChanges(class_2586 be) {
            this.applyChanges = () -> NeepBusUtil.floodUpdate(be.method_10997(), be.method_11016());
            return this;
        }
    }
}

