/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.processing;

import com.neep.neepmeat.init.NMFluids;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4174;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeatFluidUtil {
    public static final String KEY_ROOT = "neepmeat:food";
    protected static final String KEY_HUNGER = "hunger";
    protected static final String KEY_SATURATION = "saturation";
    public static final int MAX_HUNGER = 10;

    public static float getHunger(FluidVariant variant) {
        class_2487 root = MeatFluidUtil.getRoot(variant);
        if (root != null) {
            return class_3532.method_15363((float)root.method_10583(KEY_HUNGER), (float)0.0f, (float)10.0f);
        }
        return 0.0f;
    }

    public static float getHunger(@Nullable class_2487 nbt) {
        if (nbt != null) {
            class_2487 root = MeatFluidUtil.getRoot(nbt);
            return root.method_10583(KEY_HUNGER);
        }
        return 0.0f;
    }

    public static void setHunger(@NotNull class_2487 nbt, float hunger) {
        class_2487 root = MeatFluidUtil.getOrCreateRoot(nbt);
        root.method_10548(KEY_HUNGER, hunger);
    }

    public static void setSaturation(@Nullable class_2487 nbt, float saturation) {
        if (nbt != null) {
            class_2487 root = MeatFluidUtil.getOrCreateRoot(nbt);
            root.method_10548(KEY_SATURATION, saturation);
        }
    }

    public static float getSaturation(@Nullable FluidVariant variant) {
        class_2487 root = MeatFluidUtil.getRoot(variant);
        if (root != null) {
            return root.method_10583(KEY_SATURATION);
        }
        return 0.0f;
    }

    public static float getSaturation(@Nullable class_2487 nbt) {
        if (nbt != null) {
            class_2487 root = MeatFluidUtil.getOrCreateRoot(nbt);
            return root.method_10583(KEY_SATURATION);
        }
        return 0.0f;
    }

    @Nullable
    public static class_2487 getRoot(@NotNull FluidVariant variant) {
        if (variant.hasNbt()) {
            return variant.getNbt().method_10562(KEY_ROOT);
        }
        return new class_2487();
    }

    public static class_2487 getRoot(@NotNull class_2487 nbt) {
        if (nbt.method_10573(KEY_ROOT, 10)) {
            return nbt.method_10562(KEY_ROOT);
        }
        return new class_2487();
    }

    @NotNull
    public static class_2487 getRootOrNew(@Nullable class_2487 nbt) {
        class_2487 root;
        if (nbt != null && (root = MeatFluidUtil.getRoot(nbt)) != null) {
            return root;
        }
        return new class_2487();
    }

    @Contract(mutates="param1")
    protected static class_2487 getOrCreateRoot(class_2487 nbt) {
        if (nbt.method_10573(KEY_ROOT, 10)) {
            return nbt.method_10562(KEY_ROOT);
        }
        class_2487 newRoot = new class_2487();
        nbt.method_10566(KEY_ROOT, (class_2520)newRoot);
        return newRoot;
    }

    public static int getColour(FluidVariant variant) {
        float hunger = MeatFluidUtil.getHunger(variant);
        int r = (int)(255.0f * hunger / 10.0f);
        return r << 16;
    }

    public static FluidVariant getVariant(class_4174 food) {
        class_2487 nbt = new class_2487();
        nbt.method_10569(KEY_HUNGER, food.method_19230());
        nbt.method_10548(KEY_SATURATION, food.method_19231());
        class_2487 root = new class_2487();
        root.method_10566(KEY_ROOT, (class_2520)nbt);
        return FluidVariant.of((class_3611)NMFluids.STILL_C_MEAT, (class_2487)root);
    }

    private static float floor(float f, int n) {
        return (float)(Math.floor((double)f * Math.pow(10.0, n)) / (double)((float)Math.pow(10.0, n)));
    }

    public static class_2487 copyRootRounded(class_2487 nbt, class_2487 oldNbt) {
        if (oldNbt != null) {
            class_2487 root = oldNbt.method_10562(KEY_ROOT).method_10553();
            root.method_10548(KEY_HUNGER, MeatFluidUtil.floor(root.method_10583(KEY_HUNGER), 0));
            root.method_10548(KEY_SATURATION, MeatFluidUtil.floor(root.method_10583(KEY_SATURATION), 1));
            nbt.method_10566(KEY_ROOT, (class_2520)root);
        }
        return nbt;
    }

    public static void copyRoot(class_2487 from, class_2487 to) {
        class_2487 root = MeatFluidUtil.getRoot(from);
        if (root != null) {
            to.method_10566(KEY_ROOT, (class_2520)root.method_10553());
        } else {
            to.method_10566(KEY_ROOT, (class_2520)new class_2487());
        }
    }
}

