/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.processing;

import com.neep.meatlib.MeatLib;
import com.neep.neepmeat.api.processing.FluidEnegyRegistry;
import java.text.DecimalFormat;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class PowerUtils {
    public static final float MOTOR_TORQUE_LOSS = 300.0f;
    public static final long BASE_POWER = PowerUtils.referencePower();
    public static final long DROPLET_POWER = PowerUtils.dropletPower();
    public static final class_2561 POWER_UNIT = class_2561.method_43471((String)"message.neepmeat.power_unit");
    public static final class_2561 POWER = class_2561.method_43471((String)"message.neepmeat.power");
    public static final class_2561 ENERGY = class_2561.method_43471((String)"message.neepmeat.energy");
    public static final DecimalFormat POWER_FORMAT = new DecimalFormat("###.##");

    public static double perUnitToAbsolute(double perUnit) {
        return Math.round(perUnit * (double)BASE_POWER);
    }

    public static double absoluteToPerUnit(long abs) {
        return (double)abs / (double)BASE_POWER;
    }

    public static double perUnitToAbsWatt(double perUnit) {
        return PowerUtils.perUnitToAbsolute(perUnit) * 20.0;
    }

    public static class_5250 perUnitToLabelText(double perUnit) {
        return POWER.method_27662().method_10852((class_2561)class_2561.method_43470((String)POWER_FORMAT.format(PowerUtils.perUnitToAbsolute(perUnit))).method_10852(POWER_UNIT));
    }

    public static class_5250 perUnitToText(double perUnit) {
        return class_2561.method_43470((String)POWER_FORMAT.format(PowerUtils.perUnitToAbsolute(perUnit))).method_10852(POWER_UNIT);
    }

    public static String energyForRecipe(double time) {
        return PowerUtils.formatEnergy((long)(time * (double)BASE_POWER), 2);
    }

    public static String formatEnergy(long energy, int dp) {
        return MeatLib.formatEngineering(energy, dp, true, "eJ");
    }

    public static String formatPower(long power, int dp) {
        return MeatLib.formatEngineering(power, dp, true, "eJ/t");
    }

    public static long absToAmount(class_3611 fluid, long energy) {
        if (energy == 0L) {
            return 0L;
        }
        FluidEnegyRegistry.Entry entry = FluidEnegyRegistry.getInstance().getOrEmpty(fluid);
        if (entry.baseEnergy() == 0.0) {
            return 0L;
        }
        return (long)Math.floor((double)energy / entry.baseEnergy());
    }

    public static long amountToAbsEnergy(long amount, class_3611 fluid) {
        FluidEnegyRegistry.Entry entry = FluidEnegyRegistry.getInstance().getOrEmpty(fluid);
        return (long)(entry.baseEnergy() * (double)amount);
    }

    public static long fluidPower(@Nullable FluidVariant fluidVariant, long amountTransferred, int dt) {
        if (fluidVariant == null || amountTransferred == 0L || dt == 0) {
            return 0L;
        }
        FluidEnegyRegistry.Entry entry = FluidEnegyRegistry.getInstance().getOrEmpty(fluidVariant.getFluid());
        return (long)(entry.baseEnergy() * (double)amountTransferred / (double)dt);
    }

    public static long referencePower() {
        return 1000L;
    }

    public static long dropletPower() {
        return 1L;
    }
}

