/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.processing.random_ores;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.neep.meatlib.api.event.DataPackPostProcess;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.processing.random_ores.BiomeListWeightModifier;
import com.neep.neepmeat.api.processing.random_ores.BiomeTagWeightModifier;
import com.neep.neepmeat.api.processing.random_ores.RandomOreProvider;
import com.neep.neepmeat.api.processing.random_ores.WeightModifier;
import com.neep.neepmeat.datagen.tag.NMTags;
import com.neep.neepmeat.mixin.feature.CountPlacementModifierAccessor;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3037;
import net.minecraft.class_3124;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6793;
import net.minecraft.class_6797;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;

public class RandomOres
implements SimpleSynchronousResourceReloadListener {
    public static final RandomOres INSTANCE = new RandomOres();
    private final Map<class_2680, MutableEntry> stateToTempEntry = new HashMap<class_2680, MutableEntry>();
    private final List<Entry> entries = new ArrayList<Entry>();

    public static void init() {
        DataPackPostProcess.AFTER_DATA_PACK_LOAD.register(INSTANCE::postProcess);
        class_2378.method_10230(WeightModifier.REGISTRY, (class_2960)new class_2960("neepmeat", "biome_list"), BiomeListWeightModifier.CODEC);
        class_2378.method_10230(WeightModifier.REGISTRY, (class_2960)new class_2960("neepmeat", "biome_tag"), BiomeTagWeightModifier.CODEC);
    }

    public RandomOreProvider makeProvider(class_1937 world, class_2338 pos, class_5819 random) {
        return new RandomOreProvider(world, pos, random, this.entries);
    }

    public Collection<class_2960> getFabricDependencies() {
        return List.of(ResourceReloadListenerKeys.TAGS);
    }

    private void postProcess(MinecraftServer server) {
        ArrayList entryList = new ArrayList();
        class_2378 placed = server.method_30611().method_30530(class_7924.field_41245);
        placed.forEach(placedFeature -> {
            class_2975 configuredFeature = (class_2975)placedFeature.comp_334().comp_349();
            class_3037 patt2966$temp = configuredFeature.comp_333();
            if (patt2966$temp instanceof class_3124) {
                class_3124 oreFeatureConfig = (class_3124)patt2966$temp;
                for (class_6797 placement : placedFeature.comp_335()) {
                    if (!(placement instanceof class_6793)) continue;
                    class_6793 count = (class_6793)placement;
                    class_6017 intProvider = ((CountPlacementModifierAccessor)count).getCount();
                    int maxCount = intProvider.method_35011();
                    oreFeatureConfig.field_29063.forEach(t -> {
                        if (t.field_29069.method_26164(NMTags.CHARNEL_PUMP_OUTPUT_ORES)) {
                            entryList.add(new MutableEntry(t.field_29069, maxCount * oreFeatureConfig.field_13723));
                        }
                    });
                }
            }
        });
        for (MutableEntry entry : entryList) {
            MutableEntry inMap = this.stateToTempEntry.computeIfAbsent(entry.state, b -> new MutableEntry((class_2680)b, 0));
            inMap.count += entry.count;
        }
        this.entries.addAll(this.stateToTempEntry.values().stream().map(e -> new Entry(e.state, e.count, e.modifiers)).toList());
    }

    public class_2960 getFabricId() {
        return new class_2960("neepmeat", "random_ores");
    }

    public void method_14491(class_3300 manager) {
        this.stateToTempEntry.clear();
        this.entries.clear();
        for (class_2960 id : manager.method_14488("random_ores", path -> path.method_12832().endsWith(".json")).keySet()) {
            if (!manager.method_14486(id).isPresent()) continue;
            try {
                InputStream stream = ((class_3298)manager.method_14486(id).get()).method_14482();
                try {
                    InputStreamReader reader = new InputStreamReader(stream);
                    JsonElement rootElement = JsonParser.parseReader((Reader)reader);
                    JsonObject rootObject = (JsonObject)rootElement;
                    class_2680 target = (class_2680)class_2680.field_24734.parse((DynamicOps)JsonOps.INSTANCE, (Object)class_3518.method_15296((JsonObject)rootObject, (String)"state")).resultOrPartial(arg_0 -> ((Logger)NeepMeat.LOGGER).error(arg_0)).orElseThrow();
                    int count = class_3518.method_15260((JsonObject)rootObject, (String)"count");
                    List<WeightModifier> modifiers = this.parseModifiers(rootObject);
                    MutableEntry entry = new MutableEntry(target, count, modifiers);
                    this.stateToTempEntry.put(target, entry);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                NeepMeat.LOGGER.error("Error while reading random ores " + id.toString(), (Throwable)e);
            }
        }
    }

    private List<WeightModifier> parseModifiers(JsonObject root) {
        ArrayList<WeightModifier> list = new ArrayList<WeightModifier>();
        if (root.has("modifiers")) {
            JsonArray modifiers = class_3518.method_15261((JsonObject)root, (String)"modifiers");
            for (int i = 0; i < modifiers.size(); ++i) {
                JsonObject modifierObject = modifiers.get(i).getAsJsonObject();
                Codec codec = WeightModifier.CODEC.dispatch("type", WeightModifier::getCodec, Function.identity());
                WeightModifier weightModifier = (WeightModifier)codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)modifierObject).resultOrPartial(arg_0 -> ((Logger)NeepMeat.LOGGER).error(arg_0)).orElseThrow();
                list.add(weightModifier);
            }
        }
        return list;
    }

    private static class MutableEntry {
        final List<WeightModifier> modifiers;
        final class_2680 state;
        int count;

        public MutableEntry(class_2680 state, int count) {
            this(state, count, new ArrayList<WeightModifier>());
        }

        public MutableEntry(class_2680 target, int count, List<WeightModifier> modifiers) {
            this.state = target;
            this.count = count;
            this.modifiers = modifiers;
        }
    }

    public record Entry(class_2680 state, float weight, List<WeightModifier> modifiers) {
        public float modifiedWeight(class_1937 world, class_2338 pos) {
            float weight = this.weight();
            for (WeightModifier modifier : this.modifiers) {
                weight = modifier.apply(weight, world, pos);
            }
            return weight;
        }
    }
}

