/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.storage;

import com.neep.neepmeat.api.storage.LazyBlockApiCache;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class DynamicLazyBlockApiCache<A, C>
implements LazyBlockApiCache<A, C> {
    @Nullable
    private BlockApiCache<A, C> cache = null;
    private final BlockApiLookup<A, C> lookup;
    private final Supplier<class_3218> worldSupplier = () -> {
        Object patt2280$temp = worldSupplier.get();
        if (patt2280$temp instanceof class_3218) {
            class_3218 serverWorld = (class_3218)patt2280$temp;
            return serverWorld;
        }
        return null;
    };
    private final Supplier<class_2338> posSupplier;
    private final Supplier<C> ctxSupplier;

    public static <A, C> LazyBlockApiCache<A, C> of(Supplier<class_1937> worldSupplier, BlockApiLookup<A, C> lookup, Supplier<class_2338> posSupplier, Supplier<C> ctxSupplier) {
        return new DynamicLazyBlockApiCache<A, C>(worldSupplier, lookup, posSupplier, ctxSupplier);
    }

    public static <A> LazyBlockApiCache<A, class_2350> facing(BlockApiLookup<A, class_2350> lookup, class_2586 be, class_2754<class_2350> property) {
        return DynamicLazyBlockApiCache.of(() -> ((class_2586)be).method_10997(), lookup, () -> be.method_11016().method_10093((class_2350)be.method_11010().method_11654((class_2769)property)), () -> (class_2350)be.method_11010().method_11654((class_2769)property));
    }

    public static <A> LazyBlockApiCache<A, class_2350> facing(BlockApiLookup<A, class_2350> lookup, class_2586 be, Supplier<class_2350> ctxSupplier) {
        return DynamicLazyBlockApiCache.of(() -> ((class_2586)be).method_10997(), lookup, () -> be.method_11016().method_10093((class_2350)ctxSupplier.get()), () -> ((class_2350)ctxSupplier.get()).method_10153());
    }

    public static LazyBlockApiCache<Void, Void> voidCtx(BlockApiLookup<Void, Void> lookup, Supplier<class_1937> worldSupplier, Supplier<class_2338> posSupplier) {
        return DynamicLazyBlockApiCache.of(worldSupplier, lookup, posSupplier, () -> null);
    }

    private DynamicLazyBlockApiCache(Supplier<class_1937> worldSupplier, BlockApiLookup<A, C> lookup, Supplier<class_2338> posSupplier, Supplier<C> ctxSupplier) {
        this.lookup = lookup;
        this.posSupplier = posSupplier;
        this.ctxSupplier = ctxSupplier;
    }

    @Override
    public A find() {
        this.validate();
        if (this.cache != null) {
            return (A)this.cache.find(this.ctxSupplier.get());
        }
        return null;
    }

    @Override
    @Nullable
    public class_2586 getBlockEntity() {
        this.validate();
        return this.cache != null ? this.cache.getBlockEntity() : null;
    }

    @Override
    public void invalidate() {
        this.cache = null;
    }

    private void validate() {
        class_3218 world;
        if (this.cache == null && (world = this.worldSupplier.get()) != null) {
            this.cache = BlockApiCache.create(this.lookup, (class_3218)world, (class_2338)this.posSupplier.get());
        }
    }

    @Override
    public class_2338 pos() {
        return this.posSupplier.get();
    }

    @Override
    public C ctx() {
        return this.ctxSupplier.get();
    }
}

