/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.block;

import com.neep.meatlib.block.BaseBlock;
import com.neep.meatlib.item.BaseBlockItem;
import com.neep.meatlib.item.ItemSettings;
import com.neep.meatlib.registry.RegistrationContext;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.live_machine.LivingMachineBlockEntity;
import com.neep.neepmeat.api.live_machine.LivingMachineStructure;
import com.neep.neepmeat.api.live_machine.PropertyValue;
import com.neep.neepmeat.api.live_machine.StructureProperty;
import com.neep.neepmeat.block.OpenMachineBlock;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_437;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class MachineBlock
extends BaseBlock
implements LivingMachineStructure {
    private final EnumMap<StructureProperty, PropertyValue> properties;
    @Nullable
    private final Supplier<OpenMachineBlock> openVariant;

    public MachineBlock(RegistrationContext ctx, ItemSettings itemSettings, Map<StructureProperty, PropertyValue> properties, class_4970.class_2251 settings, @Nullable Supplier<OpenMachineBlock> openVariant) {
        super(ctx, itemSettings.factory(MachineBlockItem::new), settings);
        this.properties = new EnumMap<StructureProperty, PropertyValue>(properties);
        this.openVariant = openVariant;
    }

    public MachineBlock(RegistrationContext ctx, ItemSettings itemSettings, Map<StructureProperty, PropertyValue> properties, class_4970.class_2251 settings) {
        this(ctx, itemSettings, properties, settings, null);
    }

    @Override
    public boolean canOpen() {
        return this.openVariant != null;
    }

    @Override
    public boolean makeOpen(class_1937 world, class_2338 pos, class_2680 state, @Nullable LivingMachineBlockEntity be) {
        if (this.openVariant != null) {
            OpenMachineBlock openBlock = this.openVariant.get();
            LivingMachineStructure.super.makeOpen(world, pos, state, be);
            class_2338.class_2339 mutable = pos.method_25503();
            for (class_2350 face : class_2350.class_2353.field_11062) {
                mutable.method_25505((class_2382)pos, face);
                if (!world.method_8320((class_2338)mutable).method_26215()) continue;
                class_2680 newState = (class_2680)openBlock.method_9564().method_11657((class_2769)OpenMachineBlock.field_11177, (Comparable)face);
                world.method_8501(pos, newState);
                openBlock.onCreate(world, pos, newState);
                return true;
            }
        }
        return false;
    }

    @Override
    public EnumMap<StructureProperty, PropertyValue> getProperties() {
        return this.properties;
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, world, tooltip, options);
        if (!class_437.method_25442()) {
            tooltip.add((class_2561)NeepMeat.translationKey("screen", "living_machine.block_hold_shift").method_27692(class_124.field_1061));
        } else {
            tooltip.add((class_2561)NeepMeat.translationKey("screen", "living_machine.block").method_27692(class_124.field_1061));
            for (Map.Entry<StructureProperty, PropertyValue> entry : this.properties.entrySet()) {
                class_5250 base = class_2561.method_43470((String)"   ").method_10852((class_2561)NeepMeat.translationKey("screen", "living_machine." + entry.getKey().name().toLowerCase(Locale.ROOT)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1065)).method_27693(entry.getKey().format(entry.getValue())).method_10852((class_2561)class_2561.method_43470((String)(" (" + entry.getValue().function().name + ")")));
                tooltip.add((class_2561)base);
            }
        }
    }

    public static class MachineBlockItem
    extends BaseBlockItem {
        public MachineBlockItem(class_2248 block, RegistrationContext ctx, ItemSettings itemSettings) {
            super(block, ctx, itemSettings);
        }

        @Override
        public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
            super.method_7851(itemStack, world, tooltip, tooltipContext);
            this.method_7711().method_9568(itemStack, (class_1922)world, tooltip, tooltipContext);
        }
    }
}

