/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.living_machine;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatlib.client.screen.primitive.Rectangle;
import com.neep.neepmeat.api.live_machine.metrics.DataLog;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.client.screen.living_machine.LivingMachineScreen;
import com.neep.neepmeat.client.screen.util.Border;
import com.neep.neepmeat.screen_handler.LivingMachineScreenHandler;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import org.joml.Matrix4f;

public class GraphPane
extends LivingMachineScreen.PaneWidget {
    private Rectangle windowBounds;
    private Rectangle plotBounds;
    private final class_327 textRenderer;
    private final LivingMachineScreenHandler handler;
    private DataLog.DataView dataView;
    private final DecimalFormat yFormat;
    private final DecimalFormat timeFormat;

    public GraphPane(LivingMachineScreenHandler handler) {
        this.textRenderer = class_310.method_1551().field_1772;
        this.dataView = DataLog.DataView.EMPTY;
        this.yFormat = new DecimalFormat("###.#%");
        this.timeFormat = new DecimalFormat("###.#");
        this.handler = handler;
    }

    @Override
    public void tick() {
    }

    @Override
    protected void init() {
    }

    @Override
    public void init(Rectangle parentSize) {
        super.init(parentSize);
        int scaleWidth = 20;
        this.windowBounds = new Rectangle.Immutable(this.bounds.x() + scaleWidth, this.bounds.y() + 10, this.bounds.w() - 30, this.bounds.h() - 20);
        int padding = 3;
        this.plotBounds = new Rectangle.Immutable(this.windowBounds.x() + padding, this.windowBounds.y() + padding, this.windowBounds.w() - 2 * padding, this.windowBounds.h() - 2 * padding - 1);
        this.border = new Border(this.windowBounds, 0, () -> PLCCols.BORDER.col);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        long[] time = this.dataView.time();
        long period = (long)this.dataView.capacity() * 40L;
        long timeStart = time.length > 0 ? time[0] : 0L;
        long timeEnd = timeStart + period;
        long endTime = this.drawCurve(context, time, this.dataView.efficiency(), timeStart, timeEnd, PLCCols.SELECTED.col);
        this.drawCurve(context, time, this.dataView.health(), timeStart, timeEnd, PLCCols.BORDER.col);
        this.drawYScale(context, 0.0f, 1.0f, this.yFormat);
        this.drawTimeScale(context, 0L, period, endTime, this.timeFormat);
        this.drawLegend(context, this.dataView.getLegend());
    }

    private long drawCurve(class_332 context, long[] time, double[] yVals, long timeStart, long timeEnd, int col) {
        long period = timeEnd - timeStart;
        long highestTime = 0L;
        for (int i = 0; i < time.length; ++i) {
            long t1;
            if (i % 2 == 0 || (t1 = time[i]) < timeStart || t1 >= timeEnd || i + 1 >= time.length) continue;
            long t2 = time[i + 1];
            if (t2 <= timeStart || t2 > timeEnd) break;
            highestTime = t2 - timeStart;
            float y1 = (float)yVals[i];
            float y2 = (float)yVals[i + 1];
            float xStride = this.plotBounds.w();
            float yStride = this.plotBounds.h();
            float t1Scaled = (float)this.plotBounds.x() + (float)(t1 - timeStart) / (float)period * xStride;
            float t2Scaled = (float)this.plotBounds.x() + (float)(t2 - timeStart) / (float)period * xStride;
            float y1Scaled = (float)(this.plotBounds.y() + this.plotBounds.h()) - y1 * yStride;
            float y2Scaled = (float)(this.plotBounds.y() + this.plotBounds.h()) - y2 * yStride;
            this.drawLine(context, t1Scaled, y1Scaled, t2Scaled, y2Scaled, 0.5f, col);
        }
        return highestTime;
    }

    private void drawLegend(class_332 context, List<ObjectIntPair<class_2561>> entries) {
        class_4587 matrices = context.method_51448();
        float scale = 0.7f;
        for (int i = 0; i < entries.size(); ++i) {
            ObjectIntPair<class_2561> entry = entries.get(i);
            class_2561 name = (class_2561)entry.left();
            int col = entry.rightInt();
            Objects.requireNonNull(this.textRenderer);
            int squareWidth = (int)(9.0f * scale);
            float legendWidth = (float)this.textRenderer.method_27525((class_5348)name) * scale + (float)squareWidth + 1.0f;
            float f = this.windowBounds.y();
            Objects.requireNonNull(this.textRenderer);
            float y = f - 9.0f * scale;
            float x = (float)this.plotBounds.x() + ((float)i + 0.5f) * ((float)this.plotBounds.w() / (float)entries.size()) - legendWidth / 2.0f;
            context.method_25294((int)x, (int)y, (int)x + squareWidth, (int)y + squareWidth, col);
            matrices.method_22903();
            matrices.method_46416(x + (float)squareWidth + 1.0f, y, 0.0f);
            matrices.method_22905(scale, scale, 1.0f);
            GUIUtil.drawText(context, this.textRenderer, name, 0.0f, 0.0f, PLCCols.SELECTED.col, false);
            matrices.method_22909();
        }
    }

    private void drawTimeScale(class_332 context, long lower, long upper, long zero, DecimalFormat format) {
        class_4587 matrices = context.method_51448();
        long divisions = 5L;
        long period = upper - lower;
        long stride = period / divisions;
        int i = 0;
        while ((long)i < divisions + 1L) {
            long value = (long)i * stride - zero;
            String formatted = GraphPane.formatTime(value);
            float y = this.plotBounds.y() + this.plotBounds.h();
            float x = (float)this.plotBounds.x() + (float)((long)i * stride) / (float)period * (float)this.plotBounds.w();
            matrices.method_22903();
            Objects.requireNonNull(this.textRenderer);
            matrices.method_46416(x, y + 9.0f / 2.0f + 2.0f, 0.0f);
            matrices.method_22905(0.7f, 0.7f, 1.0f);
            GUIUtil.drawText(context, this.textRenderer, formatted, (float)(-this.textRenderer.method_1727(formatted)) / 2.0f, 0.0f, PLCCols.SELECTED.col, false);
            matrices.method_22909();
            int tickLength = 6;
            GUIUtil.drawVerticalLine1(context, (int)x, (int)y, (int)(y + (float)tickLength), PLCCols.SELECTED.col);
            ++i;
        }
    }

    private static String formatTime(long ticks) {
        long secs = ticks / 20L;
        Duration duration = Duration.ofSeconds(secs);
        if (duration.toHoursPart() != 0) {
            return duration.toHoursPart() + "h " + duration.toMinutesPart() + "m";
        }
        if (duration.toMinutesPart() != 0) {
            return duration.toMinutesPart() + "m " + duration.toSecondsPart() + "s";
        }
        return duration.toSecondsPart() + "s";
    }

    private void drawYScale(class_332 context, float lower, float upper, DecimalFormat format) {
        class_4587 matrices = context.method_51448();
        int divisions = 10;
        float stride = (upper - lower) / (float)divisions;
        for (int i = 0; i < divisions + 1; ++i) {
            float value = (float)i * stride;
            String formatted = format.format(value);
            float y = (float)(this.plotBounds.y() + this.plotBounds.h()) - (float)i * stride / (upper - lower) * (float)this.plotBounds.h();
            matrices.method_22903();
            float f = this.bounds.x();
            Objects.requireNonNull(this.textRenderer);
            matrices.method_46416(f, y - 9.0f / 2.0f + 2.0f, 0.0f);
            matrices.method_22905(0.7f, 0.7f, 1.0f);
            GUIUtil.drawText(context, this.textRenderer, formatted, 0.0f, 0.0f, PLCCols.SELECTED.col, false);
            matrices.method_22909();
            int tickLength = 5;
            GUIUtil.drawHorizontalLine1(context, this.plotBounds.x() - tickLength, this.plotBounds.x(), (int)y, PLCCols.SELECTED.col);
        }
    }

    public void update(class_2540 buf) {
        this.dataView = DataLog.fromBuf(buf);
    }

    private void drawLine(class_332 context, float x1, float y1, float x2, float y2, float radius, int col) {
        float z = 10.0f;
        double angle = class_3532.method_15349((double)(y2 - y1), (double)(x2 - x1));
        float l = class_3532.method_15355((float)((y2 - y1) * (y2 - y1) + (x2 - x1) * (x2 - x1)));
        float f = (float)class_5253.class_5254.method_27762((int)col) / 255.0f;
        float g = (float)class_5253.class_5254.method_27765((int)col) / 255.0f;
        float h = (float)class_5253.class_5254.method_27766((int)col) / 255.0f;
        float j = (float)class_5253.class_5254.method_27767((int)col) / 255.0f;
        Matrix4f matrix4f = new Matrix4f().identity().translate(x1, y1, 0.0f).rotateZ((float)angle);
        class_4588 vertexConsumer = context.method_51450().getBuffer(class_1921.method_51784());
        vertexConsumer.method_22918(matrix4f, 0.0f, -radius, z).method_22915(g, h, j, f).method_1344();
        vertexConsumer.method_22918(matrix4f, 0.0f, radius, z).method_22915(g, h, j, f).method_1344();
        vertexConsumer.method_22918(matrix4f, l, radius, z).method_22915(g, h, j, f).method_1344();
        vertexConsumer.method_22918(matrix4f, l, -radius, z).method_22915(g, h, j, f).method_1344();
    }
}

