/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.compat.emi.helper;

import com.neep.meatlib.recipe.ingredient.Ingredients;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_3611;

public class EmiIngredientHelper {
    public static final EmiIngredient EMPTY = EmiIngredient.of((class_1856)class_1856.field_9017);
    public static final List<EmiIngredient> EMPTY_LIST = List.of(EMPTY);

    public static List<EmiIngredient> inputsToIngredients(class_2371<RegistryRecipeInput<?>> inputs) {
        if (inputs.isEmpty()) {
            return EMPTY_LIST;
        }
        if (inputs.size() == 1) {
            RegistryRecipeInput input = (RegistryRecipeInput)inputs.get(0);
            if (input.isEmpty()) {
                return EMPTY_LIST;
            }
            return EmiIngredientHelper.inputToIngredient(input);
        }
        ArrayList<List<EmiIngredient>> result = new ArrayList<List<EmiIngredient>>(inputs.size());
        boolean emptyFlag = true;
        for (int i = inputs.size() - 1; i >= 0; --i) {
            RegistryRecipeInput input = (RegistryRecipeInput)inputs.get(i);
            if (emptyFlag && input.isEmpty()) continue;
            result.add(0, EmiIngredientHelper.inputToIngredient(input));
            emptyFlag = false;
        }
        return result.stream().flatMap(Collection::stream).toList();
    }

    public static List<EmiIngredient> inputToIngredient(RegistryRecipeInput<?> input) {
        if (input.isEmpty()) {
            return EMPTY_LIST;
        }
        if (Ingredients.ITEM.equals(input.getType())) {
            List items = (List)input.getAll();
            if (items.isEmpty()) {
                return EMPTY_LIST;
            }
            return items.stream().map(item -> EmiStack.of((class_1935)item, (long)input.amount())).toList();
        }
        if (Ingredients.FLUID.equals(input.getType())) {
            List fluids = (List)input.getAll();
            if (fluids.isEmpty()) {
                return EMPTY_LIST;
            }
            return fluids.stream().map(fluid -> EmiStack.of((class_3611)fluid, (long)input.amount())).toList();
        }
        return List.of(EmiIngredient.of(List.of()));
    }
}

