/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.compat.rei;

import com.neep.meatlib.recipe.ingredient.IngredientType;
import com.neep.meatlib.recipe.ingredient.Ingredients;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1935;
import net.minecraft.class_3611;

public class REIIngredientHelper {
    private static final Map<IngredientType<?>, Function<RegistryRecipeInput<?>, EntryIngredient>> ENTRY_STACK_MAP = new HashMap();

    public static EntryIngredient fromItem(RegistryRecipeInput<class_1935> input) {
        return EntryIngredients.ofItems(input.getAll(), (int)((int)input.amount()));
    }

    public static EntryIngredient fromFluid(RegistryRecipeInput<class_3611> input) {
        Collection<class_3611> fluids = input.getAll();
        EntryIngredient.Builder result = EntryIngredient.builder((int)fluids.size());
        for (class_3611 fluid : fluids) {
            result.add(EntryStacks.of((class_3611)fluid, (long)input.amount()));
        }
        return result.build();
    }

    public static <T> EntryIngredient entryFromInput(RegistryRecipeInput<T> input) {
        if (input.isEmpty()) {
            return EntryIngredient.empty();
        }
        Collection<T> matching = input.getAll();
        if (matching.isEmpty()) {
            return EntryIngredient.empty();
        }
        return ENTRY_STACK_MAP.get(input.getType()).apply(input);
    }

    static {
        ENTRY_STACK_MAP.put(Ingredients.ITEM, input -> REIIngredientHelper.fromItem(input));
        ENTRY_STACK_MAP.put(Ingredients.FLUID, input -> REIIngredientHelper.fromFluid(input));
    }
}

