/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.compat.rei.display;

import com.neep.neepmeat.compat.rei.NMCommonPlugin;
import com.neep.neepmeat.recipe.BlockCrushingRecipe;
import com.neep.neepmeat.recipe.CrushingRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_156;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class GrindingDisplay
extends BasicDisplay {
    private final CategoryIdentifier<?> categoryIdentifier;
    private CrushingRecipe recipe;

    public static boolean isValid(CrushingRecipe recipe) {
        return !recipe.destroy() && !(recipe instanceof BlockCrushingRecipe);
    }

    public GrindingDisplay(CategoryIdentifier<?> categoryIdentifier, CrushingRecipe recipe) {
        this(categoryIdentifier, (List)class_156.method_656(() -> {
            ArrayList<EntryIngredient> list = new ArrayList<EntryIngredient>();
            list.add(NMCommonPlugin.inputToIngredient(recipe.getItemInput()));
            return list;
        }), (List)class_156.method_656(() -> {
            ArrayList<EntryIngredient> list = new ArrayList<EntryIngredient>();
            list.add(EntryIngredients.ofItems(List.of((class_1935)recipe.getItemOutput().resource()), (int)((int)recipe.getItemOutput().minAmount())));
            ((EntryIngredient)list.get(0)).forEach(stack -> stack.tooltip(List.of(class_2561.method_30163((String)("Min: " + recipe.getItemOutput().minAmount() + ", Max: " + recipe.getItemOutput().maxAmount())))));
            if (recipe.getAuxOutput() != null) {
                list.add(EntryIngredients.ofItems(List.of((class_1935)recipe.getAuxOutput().resource()), (int)((int)recipe.getAuxOutput().minAmount())));
                ((EntryIngredient)list.get(1)).forEach(stack -> stack.tooltip(List.of(class_2561.method_30163((String)("Chance: " + recipe.getAuxOutput().chance())))));
            }
            return list;
        }), Optional.empty());
        this.recipe = recipe;
    }

    public GrindingDisplay(CategoryIdentifier<?> categoryIdentifier, List<EntryIngredient> input, List<EntryIngredient> output, Optional<class_2960> location) {
        super(input, output);
        this.categoryIdentifier = categoryIdentifier;
    }

    public static BasicDisplay.Serializer<GrindingDisplay> serializer(CategoryIdentifier<?> categoryIdentifier) {
        return BasicDisplay.Serializer.ofSimple((input, output, location1) -> new GrindingDisplay(categoryIdentifier, input, output, location1));
    }

    public static <T extends CrushingRecipe> Function<T, GrindingDisplay> filler(CategoryIdentifier<? extends GrindingDisplay> categoryIdentifier) {
        return r -> new GrindingDisplay(categoryIdentifier, (CrushingRecipe)r);
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return this.categoryIdentifier;
    }

    public double processTime() {
        return this.recipe.getTime();
    }
}

