/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.entity;

import com.neep.neepmeat.entity.WormSegment;
import com.neep.neepmeat.init.NMSounds;
import com.neep.neepmeat.util.NMMaths;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5132;

public class MachineWormEntity
extends class_1588
implements WormSegment {
    private final List<Segment> segments = new ObjectArrayList();
    private final List<class_243> prevPositions = new ObjectArrayList();

    public MachineWormEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        int segmentCount = 3;
        for (int i = 0; i < segmentCount; ++i) {
            float scale = class_3532.method_16439((float)((float)i / (float)segmentCount), (float)1.0f, (float)0.4f);
            Segment segment = new Segment(this, !this.segments.isEmpty() ? (WormSegment)this.segments.get(i - 1) : this, world, scale);
            this.segments.add(i, segment);
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(8, (class_1352)new class_1366((class_1314)this, 0.3, false));
        this.field_6201.method_6277(8, (class_1352)new class_1379((class_1314)this, 0.3));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
    }

    public class_2596<class_2602> method_18002() {
        return super.method_18002();
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8510() % 4L == 0L) {
            this.prevPositions.add(this.method_19538());
        }
        float bodyYaw = this.method_36454();
        class_243 facing = this.method_5631(0.0f, bodyYaw);
        for (int i = 0; i < this.segments.size(); ++i) {
            Segment segment = this.segments.get(i);
            segment.field_6038 = segment.method_23317();
            segment.field_5971 = segment.method_23318();
            segment.field_5989 = segment.method_23321();
            segment.field_5982 = segment.method_5705(0.0f);
            segment.updateLink();
            segment.method_5773();
        }
    }

    private static void updateLink(WormSegment parent, Segment child) {
        float parentYaw = parent.getSegmentYaw(1.0f);
        class_243 parentBackFacing = NMMaths.getRotationVector(0.0, (float)Math.PI / 180 * parentYaw).method_1021(-1.0);
        float parentRadius = parent.getSegmentDiameter() / 2.0f;
        float childRadius = child.scale / 2.0f;
        class_243 connectionPoint = parent.getSegmentPos().method_1019(parentBackFacing.method_1021((double)parentRadius));
        class_243 connectionToChild = child.method_19538().method_1020(connectionPoint);
        float angleLimit = 30.0f;
        float c2cYaw = -NMMaths.wrapDegreesPositive((float)(57.2957763671875 * Math.atan2(connectionToChild.field_1352, connectionToChild.field_1350)));
        float parentBackYaw = NMMaths.wrapDegreesPositive(parentYaw + 180.0f);
        float newAngle = MachineWormEntity.clampAngle(c2cYaw, parentBackYaw - angleLimit, parentBackYaw + angleLimit);
        class_243 childOffset = NMMaths.getRotationVector(0.0, (float)Math.PI / 180 * newAngle);
        childOffset = new class_243(childOffset.field_1352, connectionToChild.field_1351, childOffset.field_1350).method_1029().method_1021((double)childRadius);
        float childYaw = 180.0f - (float)(57.2957763671875 * Math.atan2(childOffset.field_1352, childOffset.field_1350));
        class_243 childPos = connectionPoint.method_1019(childOffset);
        child.method_5641(childPos.field_1352, childPos.field_1351, childPos.field_1350, childYaw, 0.0f);
    }

    private static float differenceBetweenAngles(float deg1, float deg2) {
        float normDeg = (deg1 - deg2) % 360.0f;
        float abs = Math.min(360.0f - normDeg, normDeg);
        return abs;
    }

    private static float clampAngle(float deg, float min, float max) {
        float nMin = class_3532.method_15393((float)(min - deg));
        float nMax = class_3532.method_15393((float)(max - deg));
        if (nMin <= 0.0f && nMax >= 0.0f) {
            return deg;
        }
        if (Math.abs(nMin) < Math.abs(nMax)) {
            return min;
        }
        return max;
    }

    private static double angle(class_243 v1, class_243 v2) {
        return Math.acos(v1.method_1026(v2) / (v1.method_1033() * v2.method_1033()));
    }

    public static class_5132 createAttributes() {
        return class_1588.method_26918().method_26866();
    }

    protected class_3414 method_6011(class_1282 source) {
        return NMSounds.MECHANICAL_MACHINE_BREAK;
    }

    protected class_3414 method_6002() {
        return NMSounds.MULTIBLOCK_DISASSEMBLE;
    }

    public boolean method_17326() {
        return true;
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    @Override
    public float getSegmentYaw(float tickDelta) {
        return this.method_5705(tickDelta);
    }

    @Override
    public float getSegmentDiameter() {
        return 1.0f;
    }

    @Override
    public class_243 getSegmentPos() {
        return this.method_19538();
    }

    public static class Segment
    extends class_1297
    implements WormSegment {
        private final MachineWormEntity head;
        private final WormSegment parent;
        public final float scale;

        public Segment(MachineWormEntity head, WormSegment parent, class_1937 world, float scale) {
            super(head.method_5864(), world);
            this.head = head;
            this.parent = parent;
            this.scale = scale;
        }

        public void method_5773() {
            super.method_5773();
            if (this.head.method_31481()) {
                this.method_31472();
            }
        }

        public void updateLink() {
            MachineWormEntity.updateLink(this.parent, this);
        }

        protected void method_5693() {
        }

        protected void method_5749(class_2487 nbt) {
        }

        protected void method_5652(class_2487 nbt) {
        }

        public boolean method_5643(class_1282 source, float amount) {
            return this.head.method_5643(source, amount);
        }

        public boolean method_31746() {
            return false;
        }

        @Override
        public float getSegmentYaw(float tickDelta) {
            return this.method_5705(tickDelta);
        }

        @Override
        public float getSegmentDiameter() {
            return this.scale;
        }

        @Override
        public class_243 getSegmentPos() {
            return this.method_19538();
        }

        public boolean method_5640(double distance) {
            return false;
        }
    }
}

