/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.implant.entity;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.implant.entity.EntityImplant;
import com.neep.neepmeat.implant.entity.EntityImplantManager;
import com.neep.neepmeat.implant.entity.ImplantRegistry;
import com.neep.neepmeat.init.NMComponents;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ClientTickingComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerImplantManager
implements EntityImplantManager,
Component,
ServerTickingComponent,
AutoSyncedComponent,
ClientTickingComponent {
    public static final String ID = "neepmeat:upgrades";
    public static final String TRANSLATION_PREFIX = "implant";
    protected final class_1657 player;
    protected Map<class_2960, EntityImplant> implants = Maps.newHashMap();

    public PlayerImplantManager(class_1657 player) {
        this.player = player;
    }

    public static class_2561 getImplantName(class_2960 id) {
        return class_2561.method_43471((String)id.method_42093(TRANSLATION_PREFIX));
    }

    @Override
    public boolean installImplant(class_2960 id) {
        ImplantRegistry.Constructor constructor = (ImplantRegistry.Constructor)ImplantRegistry.REGISTRY.method_10223(id);
        if (constructor != null) {
            if (!this.player.method_37908().method_8608()) {
                this.player.method_7353((class_2561)class_2561.method_43469((String)"message.neepmeat.implant.install", (Object[])new Object[]{PlayerImplantManager.getImplantName(id)}), true);
            }
            this.addImplant(constructor);
            return true;
        }
        NeepMeat.LOGGER.error("Tried to add an unregistered implant to player {}", (Object)this.player.method_5820());
        return false;
    }

    protected EntityImplant addImplant(ImplantRegistry.Constructor constructor) {
        EntityImplant implant = constructor.create((class_1297)this.player);
        this.implants.put(implant.getId(), implant);
        Multimap<class_1320, class_1322> modifiers = implant.getModifiers();
        implant.onInstall();
        if (!modifiers.isEmpty()) {
            this.player.method_6127().method_26854(modifiers);
        }
        this.sync();
        return implant;
    }

    @Override
    public boolean removeImplant(class_2960 id) {
        EntityImplant upgrade = this.implants.get(id);
        if (upgrade != null) {
            upgrade.onUninstall();
            Multimap<class_1320, class_1322> modifiers = upgrade.getModifiers();
            if (!modifiers.isEmpty()) {
                this.player.method_6127().method_26847(modifiers);
            }
            this.implants.remove(id);
            this.sync();
            return true;
        }
        return false;
    }

    @Override
    public Set<class_2960> getInstalled() {
        return this.implants.keySet();
    }

    public float getProtectionAmount(class_1282 source, float amount) {
        return (float)this.implants.values().stream().mapToDouble(u -> u.getProtectionAmount(source, amount)).sum();
    }

    public static PlayerImplantManager get(class_1657 player) {
        return (PlayerImplantManager)player.getComponent(NMComponents.IMPLANT_MANAGER);
    }

    @Override
    @Nullable
    public <T extends EntityImplant> T getImplant(class_2960 id) {
        if (this.implants.isEmpty()) {
            return null;
        }
        return (T)this.implants.get(id);
    }

    public void serverTick() {
        Iterator<EntityImplant> it = this.implants.values().iterator();
        while (it.hasNext()) {
            it.next().tick(it::remove);
        }
    }

    public void clientTick() {
        this.implants.values().forEach(EntityImplant::clientTick);
    }

    public void readFromNbt(@NotNull class_2487 nbt) {
        class_2499 list = nbt.method_10554("upgrades", 10);
        this.implants.clear();
        list.forEach(nbt1 -> {
            class_2487 implantNbt = (class_2487)nbt1;
            class_2960 id = class_2960.method_12829((String)implantNbt.method_10558("id"));
            ImplantRegistry.Constructor constructor = (ImplantRegistry.Constructor)ImplantRegistry.REGISTRY.method_10223(id);
            if (constructor != null) {
                EntityImplant implant = this.addImplant(constructor);
                implant.readNbt(implantNbt);
            }
        });
    }

    public void writeToNbt(@NotNull class_2487 nbt) {
        class_2499 list = new class_2499();
        this.implants.forEach((i, u) -> {
            class_2487 nbt1 = new class_2487();
            nbt1.method_10582("id", i.toString());
            u.writeNbt(nbt1);
            list.add((Object)nbt1);
        });
        nbt.method_10566("upgrades", (class_2520)list);
    }

    @Override
    public void sync() {
        NMComponents.IMPLANT_MANAGER.sync((Object)this.player);
    }

    public static void init() {
        ServerPlayConnectionEvents.INIT.register((handler, server) -> PlayerImplantManager.get((class_1657)handler.method_32311()).implants.values().forEach(EntityImplant::onPlayerInit));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            PlayerImplantManager manager = PlayerImplantManager.get((class_1657)handler.method_32311());
            manager.implants.values().forEach(EntityImplant::onPlayerRemove);
        });
    }

    @Override
    public void onDeath() {
        if (!this.player.method_37908().method_8608()) {
            Iterator<EntityImplant> it = this.implants.values().iterator();
            while (it.hasNext()) {
                it.next().onDeath(it::remove);
            }
        }
    }
}

