/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.item;

import com.neep.meatlib.item.BaseItem;
import com.neep.meatlib.item.TooltipSupplier;
import com.neep.neepmeat.fluid.PersistentFluid;
import com.neep.neepmeat.util.MiscUtil;
import net.fabricmc.fabric.api.lookup.v1.item.ItemApiLookup;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class PipetteItem
extends BaseItem {
    protected static ItemApiLookup.ItemApiProvider<Storage<FluidVariant>, ContainerItemContext> API_PROVIDER = (stack, context) -> new StackStorage((ContainerItemContext)context);

    public PipetteItem(TooltipSupplier tooltip, class_1792.class_1793 settings) {
        super(tooltip, settings);
        FluidStorage.ITEM.registerForItems(API_PROVIDER, new class_1935[]{this});
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 pipetteStack = user.method_5998(hand);
        class_3965 blockHitResult = PipetteItem.method_7872((class_1937)world, (class_1657)user, (class_3959.class_242)class_3959.class_242.field_1347);
        class_2338 pos = blockHitResult.method_17777();
        if (blockHitResult.method_17783() == class_239.class_240.field_1332) {
            if (!world.method_8505(user, pos)) {
                return class_1271.method_22431((Object)pipetteStack);
            }
            class_2680 state = world.method_8320(blockHitResult.method_17777());
            class_3610 fluidState = state.method_26227();
            class_3611 class_36112 = fluidState.method_15772();
            if (class_36112 instanceof PersistentFluid) {
                PersistentFluid fluid = (PersistentFluid)class_36112;
                long amount = fluid.getAmount(fluidState);
                FluidVariant variant = fluid.getVariant(fluidState);
                if (amount > 0L) {
                    try (Transaction transaction = Transaction.openOuter();){
                        StackStorage pipetteStorage = new StackStorage(ContainerItemContext.ofPlayerHand((class_1657)user, (class_1268)hand));
                        long inserted = pipetteStorage.insert(variant, amount, (TransactionContext)transaction);
                        if (fluid.extractOrNothing(world, pos, fluidState, inserted)) {
                            transaction.commit();
                        }
                        class_1271 class_12712 = class_1271.method_22427((Object)user.method_5998(hand));
                        return class_12712;
                    }
                }
            }
        }
        return class_1271.method_22430((Object)pipetteStack);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        if (!world.method_8608() && context.method_8036() != null) {
            Storage blockStorage = (Storage)FluidStorage.SIDED.find(world, context.method_8037(), (Object)context.method_8038());
            Storage itemStorage = (Storage)FluidStorage.ITEM.find(context.method_8041(), (Object)ContainerItemContext.ofPlayerHand((class_1657)context.method_8036(), (class_1268)context.method_20287()));
            if (context.method_8036().method_5715() && itemStorage != null && blockStorage == null) {
                try (Transaction transaction = Transaction.openOuter();){
                    FluidVariant resource = (FluidVariant)StorageUtil.findExtractableResource((Storage)itemStorage, (TransactionContext)transaction);
                    if (resource != null && !resource.isBlank()) {
                        itemStorage.extract((Object)resource, Long.MAX_VALUE, (TransactionContext)transaction);
                        world.method_8396(null, context.method_8037(), class_3417.field_14876, class_3419.field_15248, 0.2f, 1.0f);
                    }
                    transaction.commit();
                }
            } else if (blockStorage != null && itemStorage != null) {
                if (StorageUtil.move((Storage)blockStorage, (Storage)itemStorage, variant -> true, (long)Long.MAX_VALUE, null) > 0L) {
                    world.method_8396(null, context.method_8037(), class_3417.field_15126, class_3419.field_15248, 0.2f, 1.0f);
                    context.method_8036().method_7259(class_3468.field_15372.method_14956((Object)this));
                    return class_1269.field_5812;
                }
                if (StorageUtil.move((Storage)itemStorage, (Storage)blockStorage, variant -> true, (long)Long.MAX_VALUE, null) > 0L) {
                    world.method_8396(null, context.method_8037(), class_3417.field_14834, class_3419.field_15248, 0.2f, 1.0f);
                    context.method_8036().method_7259(class_3468.field_15372.method_14956((Object)this));
                    return class_1269.field_5812;
                }
            }
        }
        return super.method_7884(context);
    }

    public class_2561 method_7864(class_1799 stack) {
        FluidVariant variant = StackStorage.getResource(ItemVariant.of((class_1799)stack));
        long amount = StackStorage.getAmount(ItemVariant.of((class_1799)stack));
        if (amount > 0L) {
            return class_2561.method_43469((String)(this.method_7876() + ".full"), (Object[])new Object[]{FluidVariantAttributes.getName((FluidVariant)variant), MiscUtil.dropletsToMb(amount)});
        }
        return class_2561.method_43471((String)this.method_7866(stack));
    }

    public String method_7866(class_1799 stack) {
        return super.method_7866(stack);
    }

    public static class StackStorage
    implements SingleSlotStorage<FluidVariant> {
        public static final String KEY_ROOT = "neepmeat:storage";
        public static final String KEY_RESOURCE = "resource";
        public static final String KEY_AMOUNT = "amount";
        public static final String KEY_CAPACITY = "capacity";
        protected final ContainerItemContext context;
        protected final long capacity;

        public StackStorage(ContainerItemContext context) {
            this.context = context;
            this.capacity = 81000L;
        }

        public static FluidVariant getResource(ItemVariant stack) {
            class_2487 nbt = stack.copyOrCreateNbt();
            class_2487 root = nbt.method_10562(KEY_ROOT);
            return FluidVariant.fromNbt((class_2487)root.method_10562(KEY_RESOURCE));
        }

        public static long getAmount(ItemVariant stack) {
            class_2487 nbt = stack.copyOrCreateNbt();
            class_2487 root = nbt.method_10562(KEY_ROOT);
            return root.method_10537(KEY_AMOUNT);
        }

        public long insert(FluidVariant insertedResource, long maxAmount, TransactionContext transaction) {
            long insertedAmount;
            StoragePreconditions.notBlankNotNegative((TransferVariant)insertedResource, (long)maxAmount);
            long amount = this.getAmount();
            FluidVariant resource = this.getResource();
            if ((insertedResource.equals(resource) || resource.isBlank()) && (insertedAmount = Math.min(maxAmount, this.getCapacity() - amount)) > 0L) {
                if (resource.isBlank()) {
                    this.setResource(insertedResource, transaction);
                    this.setAmount(insertedAmount, transaction);
                } else {
                    this.setAmount(amount + insertedAmount, transaction);
                }
                return insertedAmount;
            }
            return 0L;
        }

        public long extract(FluidVariant extractedResource, long maxAmount, TransactionContext transaction) {
            long extractedAmount;
            StoragePreconditions.notBlankNotNegative((TransferVariant)extractedResource, (long)maxAmount);
            FluidVariant resource = this.getResource();
            long amount = this.getAmount();
            if (extractedResource.equals(resource) && (extractedAmount = Math.min(maxAmount, amount)) > 0L) {
                this.setAmount(amount - extractedAmount, transaction);
                if (amount - extractedAmount == 0L) {
                    this.setResource(FluidVariant.blank(), transaction);
                }
                return extractedAmount;
            }
            return 0L;
        }

        public boolean isResourceBlank() {
            return this.getResource().isBlank();
        }

        public FluidVariant getResource() {
            return StackStorage.getResource(this.context.getItemVariant());
        }

        public void setResource(FluidVariant resource, TransactionContext transaction) {
            ItemVariant stack = this.context.getItemVariant();
            class_2487 nbt = stack.copyOrCreateNbt();
            class_2487 root = nbt.method_10562(KEY_ROOT);
            root.method_10566(KEY_RESOURCE, (class_2520)resource.toNbt());
            nbt.method_10566(KEY_ROOT, (class_2520)root);
            this.context.exchange(ItemVariant.of((class_1935)stack.getItem(), (class_2487)nbt), 1L, transaction);
        }

        public long getAmount() {
            return StackStorage.getAmount(this.context.getItemVariant());
        }

        public void setAmount(long amount, TransactionContext transaction) {
            ItemVariant stack = this.context.getItemVariant();
            class_2487 nbt = stack.copyOrCreateNbt();
            class_2487 root = nbt.method_10562(KEY_ROOT);
            root.method_10544(KEY_AMOUNT, amount);
            nbt.method_10566(KEY_ROOT, (class_2520)root);
            this.context.exchange(ItemVariant.of((class_1935)stack.getItem(), (class_2487)nbt), 1L, transaction);
        }

        public long getCapacity() {
            return this.capacity;
        }
    }
}

