/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.item.filter;

import com.neep.meatlib.api.network.ParamCodec;
import com.neep.meatlib.util.NbtSerialisable;
import com.neep.neepmeat.item.filter.Filter;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class FilterList
implements NbtSerialisable {
    public static final ParamCodec<FilterList> CODEC = ParamCodec.of(FilterList.class, FilterList::write, FilterList::read);
    protected final List<Entry> entries = new ObjectArrayList();
    protected final int maxEntries;
    private final Runnable markDirty;

    public FilterList(int maxEntries, Runnable markDirty) {
        this.maxEntries = maxEntries;
        this.markDirty = markDirty;
    }

    public boolean matches(ItemVariant variant) {
        if (this.isEmpty()) {
            return true;
        }
        for (Entry entry : this.entries) {
            if (!entry.matches(variant)) continue;
            return true;
        }
        return false;
    }

    public void add(Filter filter) {
        if (this.entries.size() < this.maxEntries) {
            this.entries.add(new Entry(filter));
        }
    }

    public void remove(int i) {
        this.entries.remove(i);
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public void write(class_2540 buf) {
        buf.writeInt(this.maxEntries);
        buf.method_10794(this.writeNbt(new class_2487()));
    }

    public static FilterList read(class_2540 buf) {
        int maxEntries = buf.readInt();
        FilterList filterList = new FilterList(maxEntries, () -> {});
        class_2487 nbt = buf.method_10798();
        if (nbt != null) {
            filterList.readNbt(nbt);
        }
        return filterList;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (Entry entry : this.entries) {
            class_2487 entryNbt = new class_2487();
            entryNbt.method_10582("id", Filter.REGISTRY.method_10221(entry.filter.getType()).toString());
            entryNbt.method_10556("entry_inverted", entry.getInverted());
            list.add((Object)entry.filter.writeNbt(entryNbt));
        }
        nbt.method_10566("entries", (class_2520)list);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.entries.clear();
        class_2499 list = nbt.method_10554("entries", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 entryNbt = list.method_10602(i);
            class_2960 id = class_2960.method_12829((String)entryNbt.method_10558("id"));
            Filter.Constructor constructor = (Filter.Constructor)Filter.REGISTRY.method_10223(id);
            if (constructor == null) continue;
            Entry entry = new Entry((Filter)constructor.create());
            entry.setInverted(entryNbt.method_10577("entry_inverted"));
            entry.update(entryNbt);
            this.entries.add(entry);
        }
    }

    public Filter getFilter(int i) {
        return this.entries.get((int)i).filter;
    }

    public void markDirty() {
        this.markDirty.run();
    }

    public static class Entry {
        private final Filter filter;
        private boolean inverted = false;

        public Entry(Filter filter) {
            this.filter = filter;
        }

        public boolean matches(ItemVariant variant) {
            return this.filter.matches(variant) == !this.inverted;
        }

        public void update(class_2487 nbt) {
            this.filter.readNbt(nbt);
        }

        public void setInverted(boolean inverted) {
            this.inverted = inverted;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public boolean getInverted() {
            return this.inverted;
        }
    }
}

