/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.item.filter;

import com.neep.neepmeat.item.filter.Filter;
import com.neep.neepmeat.item.filter.Filters;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class ItemFilter
implements Filter {
    private final List<ItemVariant> items = class_2371.method_10213((int)10, (Object)ItemVariant.blank());
    private boolean useNbt = false;
    private boolean useDamage = false;

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        class_2499 itemList = new class_2499();
        for (ItemVariant item : this.items) {
            itemList.add((Object)item.toNbt());
        }
        nbt.method_10566("items", (class_2520)itemList);
        nbt.method_10556("use_nbt", this.useNbt);
        nbt.method_10556("use_damage", this.useDamage);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        class_2499 itemList = nbt.method_10554("items", 10);
        for (int i = 0; i < itemList.size(); ++i) {
            this.items.set(i, ItemVariant.fromNbt((class_2487)itemList.method_10602(i)));
        }
        this.useNbt = nbt.method_10577("use_nbt");
        this.useDamage = nbt.method_10577("use_damage");
    }

    public List<ItemVariant> getItems() {
        return this.items;
    }

    public void setItem(int index, ItemVariant item) {
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        this.items.set(index, item);
    }

    public ItemVariant getItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemVariant.blank();
        }
        return this.items.get(index);
    }

    @Override
    public boolean matches(ItemVariant variant) {
        for (ItemVariant item : this.items) {
            if (!this.testItem(item, variant)) continue;
            return true;
        }
        return false;
    }

    private boolean testItem(ItemVariant filterItem, ItemVariant variant) {
        int itemDamage;
        boolean itemsEqual;
        boolean bl = itemsEqual = variant.getItem() == filterItem.getItem();
        if (!this.useNbt && !this.useDamage) {
            return itemsEqual;
        }
        class_2487 filterNbt = filterItem.getNbt();
        class_2487 nbt = variant.getNbt();
        int filterDamage = filterNbt == null ? 0 : filterNbt.method_10550("Damage");
        int n = itemDamage = nbt == null ? 0 : nbt.method_10550("Damage");
        if (this.useDamage && !this.useNbt) {
            return itemsEqual && filterDamage == itemDamage;
        }
        return itemsEqual && Objects.equals(filterNbt, nbt);
    }

    @Override
    public Filter.Constructor<?> getType() {
        return Filters.ITEM;
    }

    public boolean ignoreDamage() {
        return this.useDamage;
    }

    public boolean ignoreNbt() {
        return this.useNbt;
    }

    public void setUseDamage(boolean useDamage) {
        this.useDamage = useDamage;
        if (!useDamage) {
            this.useNbt = false;
        }
    }

    public void setUseNbt(boolean useNbt) {
        this.useNbt = useNbt;
        if (useNbt) {
            this.useDamage = true;
        }
    }
}

