/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.breaker;

import com.neep.meatlib.block.BaseFacingBlock;
import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.machine.motor.MotorEntity;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3341;
import net.minecraft.class_5575;

public class LinearOscillatorBlockEntity
extends SyncableBlockEntity
implements MotorisedBlock {
    public static final String NBT_COOLDOWN = "cooldown";
    public static final String NBT_MAX_COOLDOWN = "max_cooldown";
    public static long BASE_WORK_AMOUNT = 5062L;
    public static float INCREMENT_MAX = 2.0f;
    public static float INCREMENT_MIN = 0.1f;
    public int cooldownTicks = 40;
    public float cooldown = 0.0f;
    private float cooldownIncrement;
    public float prevExtension = 0.0f;
    public float extension = 0.0f;
    public boolean extended = false;
    protected boolean running;
    public long extensionTime = 0L;
    public float clientExtension = 0.0f;
    private float power;

    public LinearOscillatorBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.LINEAR_OSCILLATOR, pos, state);
    }

    public LinearOscillatorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void tick() {
        INCREMENT_MAX = 2.0f;
        if (!this.running) {
            return;
        }
        this.cooldown = Math.max(0.0f, this.cooldown - this.cooldownIncrement);
        this.cooldownTicks = 40;
        if (this.cooldown <= 0.0f) {
            this.extend();
        } else {
            this.extended = false;
        }
        this.prevExtension = this.extension;
        this.extension = this.cooldown / (float)this.cooldownTicks;
        this.sync();
    }

    public void extend() {
        if (this.field_11863.method_49803(this.field_11867)) {
            return;
        }
        this.cooldown = this.cooldownTicks;
        this.extended = true;
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)BaseFacingBlock.field_10927);
        class_2338 facingPos = this.method_11016().method_10093(facing);
        class_2680 facingState = this.field_11863.method_8320(facingPos);
        float hardness = facingState.method_26214((class_1922)this.field_11863, facingPos);
        if (!facingState.method_26215() && facingState.method_26227().method_15769() && hardness >= 0.0f && hardness < class_2246.field_10540.method_36555()) {
            this.method_10997().method_22352(facingPos, true);
        }
        class_238 box = class_238.method_19316((class_3341)class_3341.method_34390((class_2382)facingPos, (class_2382)facingPos));
        List entities = this.field_11863.method_18023(class_5575.method_31795(class_1309.class), box, entity -> true);
        entities.forEach(entity -> {
            entity.method_5643(this.field_11863.method_48963().method_48830(), this.power * 20.0f);
            double mult = 0.5;
            entity.method_5762((double)facing.method_10148() * mult, (double)facing.method_10164() * mult, (double)facing.method_10165() * mult);
        });
    }

    public boolean onUse(class_1657 player, class_1268 hand) {
        return false;
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.cooldownTicks = nbt.method_10550(NBT_MAX_COOLDOWN);
        this.cooldown = nbt.method_10583(NBT_COOLDOWN);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569(NBT_MAX_COOLDOWN, this.cooldownTicks);
        nbt.method_10548(NBT_COOLDOWN, this.cooldown);
    }

    @Override
    public void fromClientTag(class_2487 nbt) {
        this.prevExtension = nbt.method_10583("prev_extension");
        this.extension = nbt.method_10583("extension");
        if (this.cooldown == (float)this.cooldownTicks) {
            this.extensionTime = nbt.method_10537("world_time");
        }
    }

    @Override
    public void toClientTag(class_2487 nbt) {
        nbt.method_10544("world_time", this.method_10997().method_8510());
        nbt.method_10548("prev_extension", this.prevExtension);
        nbt.method_10548("extension", this.extension);
    }

    @Override
    public boolean motorTick(MotorEntity motor) {
        this.tick();
        return true;
    }

    @Override
    public void setInputPower(float power) {
        this.running = power != 0.0f;
        this.power = power;
        this.cooldownIncrement = INCREMENT_MIN + power * (INCREMENT_MAX - INCREMENT_MIN);
    }
}

