/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.content_detector;

import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.machine.content_detector.InventoryDetector;
import com.neep.neepmeat.machine.content_detector.InventoryDetectorBlock;
import com.neep.neepmeat.screen_handler.ContentDetectorScreenHandler;
import com.neep.neepmeat.transport.block.item_transport.machine.InventoryDetectorInventory;
import com.neep.neepmeat.util.FilterUtils;
import com.neep.neepmeat.util.ItemUtil;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;

public class InventoryDetectorBlockEntity
extends class_2586
implements class_3908,
InventoryDetector {
    public static final String NBT_POWERED = "powered";
    public static final String NBT_MODE = "mode";
    public static final String NBT_COUNT_MODE = "count_mode";
    public static final String NBT_BEHAVIOUR_MODE = "behaviour_mode";
    public InventoryDetectorInventory filterInventory = new InventoryDetectorInventory();
    protected BlockApiCache<Storage<ItemVariant>, class_2350> cache;
    protected boolean powered;
    protected int mode = 0;
    protected InventoryDetector.CountMode countMode = InventoryDetector.CountMode.ANY_AMOUNT;
    protected InventoryDetector.BehaviourMode behaviourMode = InventoryDetector.BehaviourMode.REGULATE;
    private boolean prevPowered;

    public InventoryDetectorBlockEntity(class_2338 pos, class_2680 state) {
        super(NMBlockEntities.INVENTORY_DETECTOR, pos, state);
    }

    public InventoryDetectorBlockEntity(class_2591<InventoryDetectorBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public InventoryDetector.CountMode getCountMode() {
        return this.countMode;
    }

    @Override
    public void cycleCountMode() {
        this.countMode = InventoryDetector.CountMode.values()[(this.countMode.ordinal() + 1) % InventoryDetector.CountMode.values().length];
        this.method_5431();
    }

    @Override
    public InventoryDetector.BehaviourMode getBehaviourMode() {
        return this.behaviourMode;
    }

    @Override
    public void cycleBehaviourMode() {
        this.behaviourMode = InventoryDetector.BehaviourMode.values()[(this.behaviourMode.ordinal() + 1) % InventoryDetector.BehaviourMode.values().length];
        this.method_5431();
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.filterInventory.writeNbt(tag);
        tag.method_10556(NBT_POWERED, this.powered);
        tag.method_10569(NBT_MODE, this.mode);
        tag.method_10569(NBT_COUNT_MODE, this.countMode.ordinal());
        tag.method_10569(NBT_BEHAVIOUR_MODE, this.behaviourMode.ordinal());
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.filterInventory.readNbt(tag);
        this.powered = tag.method_10577(NBT_POWERED);
        this.mode = tag.method_10550(NBT_MODE);
        this.countMode = InventoryDetector.CountMode.values()[tag.method_10550(NBT_COUNT_MODE)];
        this.behaviourMode = InventoryDetector.BehaviourMode.values()[tag.method_10550(NBT_BEHAVIOUR_MODE)];
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new ContentDetectorScreenHandler(syncId, inv, this.filterInventory, this);
    }

    public void refreshCache() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)InventoryDetectorBlock.field_10927);
            this.cache = BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)serverWorld, (class_2338)this.field_11867.method_10093(facing));
        }
    }

    public void observeStorage() {
        Storage observedStorage;
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)InventoryDetectorBlock.field_10927);
        if (this.cache != null && (observedStorage = (Storage)this.cache.find((Object)facing.method_10153())) != null) {
            try (Transaction transaction = Transaction.openOuter();){
                List<ItemVariant> variants = StreamSupport.stream(InventoryStorage.of((class_1263)this.filterInventory, (class_2350)facing).spliterator(), false).filter(ItemUtil::notBlank).map(StorageView::getResource).distinct().collect(Collectors.toList());
                FilterUtils.Filter filter = switch (this.countMode) {
                    case InventoryDetector.CountMode.GREATER_IN_FILTER -> (obs, filt) -> obs < filt;
                    case InventoryDetector.CountMode.GREATER_IN_STORAGE -> (obs, filt) -> obs > filt;
                    case InventoryDetector.CountMode.EQUAL -> (obs, filt) -> obs == filt;
                    default -> (obs, filt) -> true;
                };
                List<ItemVariant> filtered = variants.stream().filter(variant -> {
                    Optional<Long> observedView = ItemUtil.totalAmount(InventoryStorage.of((class_1263)this.filterInventory, (class_2350)facing.method_10153()), variant, transaction);
                    Optional<Long> filterView = ItemUtil.totalAmount(observedStorage, variant, transaction);
                    if (observedView.isPresent() && filterView.isPresent()) {
                        return filter.test(filterView.get(), observedView.get());
                    }
                    return false;
                }).toList();
                int size = filtered.size();
                int size2 = StreamSupport.stream(observedStorage.spliterator(), false).map(StorageView::getResource).filter(FilterUtils.containsVariant(variants)).toList().size();
                if (this.behaviourMode == InventoryDetector.BehaviourMode.REGULATE) {
                    if (this.mode == 0) {
                        if (size == variants.size() && size != 0) {
                            this.powered = true;
                            this.mode = 1;
                        }
                    } else if (this.mode == 1 && size2 == 0) {
                        this.powered = false;
                        this.mode = 0;
                    }
                } else if (this.behaviourMode == InventoryDetector.BehaviourMode.ABSOLUTE) {
                    this.powered = size == variants.size();
                }
                transaction.commit();
            }
        } else {
            this.powered = false;
        }
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, InventoryDetectorBlockEntity be) {
        if (world.method_8510() % 10L != 0L) {
            return;
        }
        if (be.cache == null) {
            be.refreshCache();
        }
        be.observeStorage();
        if (be.prevPowered != be.powered) {
            be.prevPowered = be.powered;
            class_2680 newState = (class_2680)state.method_11657((class_2769)InventoryDetectorBlock.POWERED, (Comparable)Boolean.valueOf(be.powered));
            world.method_8652(pos, newState, 2);
            be.updateNeighbors(world, pos, state);
        }
    }

    protected void updateNeighbors(class_1937 world, class_2338 pos, class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)InventoryDetectorBlock.field_10927);
        class_2338 blockPos = pos.method_10093(direction.method_10153());
        world.method_8492(blockPos, state.method_26204(), pos);
        world.method_8508(blockPos, state.method_26204(), direction);
    }

    public Storage<ItemVariant> getStorage(class_2350 ignored) {
        return this.filterInventory.getStorage();
    }
}

