/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.homogeniser;

import com.google.common.collect.Maps;
import com.neep.neepmeat.api.processing.MeatFluidUtil;
import com.neep.neepmeat.init.NMFluids;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_3611;

public class MeatAdditives {
    private static final MeatAdditives INSTANCE = new MeatAdditives();
    private final Map<class_1792, Entry> map = Maps.newHashMap();

    public static MeatAdditives getInstance() {
        return INSTANCE;
    }

    public static void register(class_1792 item, Entry entry) {
        MeatAdditives.getInstance().map.put(item, entry);
    }

    public Entry get(class_1792 item) {
        return this.map.get(item);
    }

    public static void init() {
        MeatAdditives.register(class_1802.field_8479, new HungerAdditive(1.0f, 81000L));
    }

    public static interface Entry {
        public long getAmount();

        public boolean canApply(FluidVariant var1);

        public FluidVariant apply(FluidVariant var1);
    }

    public static class HungerAdditive
    implements Entry {
        private final float hunger;
        private final long amount;

        public HungerAdditive(float hunger, long amount) {
            this.hunger = hunger;
            this.amount = amount;
        }

        @Override
        public long getAmount() {
            return this.amount;
        }

        @Override
        public boolean canApply(FluidVariant variant) {
            return variant.isOf((Object)NMFluids.STILL_C_MEAT);
        }

        @Override
        public FluidVariant apply(FluidVariant variant) {
            class_2487 newNbt = new class_2487();
            if (MeatFluidUtil.getRoot(variant) != null) {
                MeatFluidUtil.copyRoot(variant.getNbt(), newNbt);
            }
            MeatFluidUtil.setHunger(newNbt, MeatFluidUtil.getHunger(variant) + this.hunger);
            return FluidVariant.of((class_3611)variant.getFluid(), (class_2487)newNbt);
        }
    }
}

