/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.item_mincer;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.api.FluidPump;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import com.neep.neepmeat.api.processing.MeatFluidUtil;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.api.storage.WritableStackStorage;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.machine.item_mincer.ItemMincerBlock;
import com.neep.neepmeat.machine.item_mincer.ItemMincerStorage;
import com.neep.neepmeat.machine.motor.MotorEntity;
import com.neep.neepmeat.transport.api.AutoEjector;
import com.neep.neepmeat.transport.fluid_network.node.AcceptorModes;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4174;

public class ItemMincerBlockEntity
extends SyncableBlockEntity
implements MotorisedBlock,
MotorisedBlock.DiagnosticsProvider {
    protected float power;
    protected State state = State.IDLE;
    protected float processEnergy;
    protected ItemMincerStorage storage;
    protected final AutoEjector<FluidVariant> ejector;
    protected final FluidPump pump = new FluidPump(){

        @Override
        public float getFlow() {
            return -0.5f;
        }

        @Override
        public AcceptorModes getMode() {
            return AcceptorModes.PUSH;
        }

        @Override
        public boolean isStorage() {
            return true;
        }
    };
    private double angle;

    public ItemMincerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.storage = new ItemMincerStorage(this);
        this.ejector = this.addListener(AutoEjector.simpleFluid(() -> (class_2350)state.method_11654((class_2769)ItemMincerBlock.field_11177), this, (Storage<FluidVariant>)this.storage.outputStorage, this.pump));
    }

    public ItemMincerBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.ITEM_MINCER, pos, state);
    }

    @Override
    public boolean motorTick(MotorEntity motor) {
        try (Transaction transaction = Transaction.openOuter();){
            switch (this.state) {
                case IDLE: {
                    int energy = this.canStart();
                    if (energy == 0) break;
                    this.state = State.PROCESSING;
                    this.processEnergy = energy;
                    this.sync();
                    break;
                }
                case PROCESSING: {
                    this.processEnergy = Math.max(0.0f, this.processEnergy - this.power);
                    if (!(this.processEnergy <= 0.0f)) break;
                    this.produceOutput((TransactionContext)transaction);
                    this.state = State.IDLE;
                }
            }
            transaction.commit();
        }
        this.ejector.tick(null);
        return true;
    }

    protected int canStart() {
        if (!this.storage.inputStorage.isEmpty()) {
            class_4174 food = ((class_1792)((ItemVariant)this.storage.inputStorage.getResource()).getObject()).method_19264();
            return food != null ? (food.method_19234() ? 8 : 16) : 0;
        }
        return 0;
    }

    protected void produceOutput(TransactionContext context) {
        if (this.canStart() > 0) {
            try (Transaction inner = context.openNested();){
                class_4174 food = ((class_1792)((ItemVariant)this.storage.inputStorage.getResource()).getObject()).method_19264();
                FluidVariant outputVariant = MeatFluidUtil.getVariant(food);
                this.storage.outputStorage.insert(outputVariant, 9000L, (TransactionContext)inner);
                this.storage.inputStorage.extract((TransferVariant)((ItemVariant)this.storage.inputStorage.getResource()), 1L, (TransactionContext)inner);
                inner.commit();
            }
        }
    }

    public void clientTick() {
        this.angle += 1.1;
        if (this.state == State.PROCESSING && !this.storage.inputStorage.isEmpty() && this.power > 0.0f) {
            double radius = 0.2;
            double cx = (double)this.method_11016().method_10263() + 0.5;
            double cy = this.method_11016().method_10264() + 1;
            double cz = (double)this.method_11016().method_10260() + 0.5;
            double px = cx + Math.sin(this.angle) * radius;
            double pz = cz + Math.cos(this.angle) * radius;
            double vx = (px - cx) * 0.5;
            double vy = 0.35;
            double vz = (pz - cz) * 0.5;
            this.field_11863.method_8406((class_2394)new class_2392(class_2398.field_11218, this.storage.inputStorage.getAsStack()), px, cy, pz, vx, vy, vz);
        }
    }

    @Override
    public void setInputPower(float power) {
        this.power = power;
        this.sync();
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10548("power", this.power);
        nbt.method_10569("state", this.state.ordinal());
        nbt.method_10548("energy", this.processEnergy);
        this.storage.writeNbt(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.power = nbt.method_10583("power");
        this.state = State.values()[nbt.method_10550("state")];
        this.processEnergy = nbt.method_10583("energy");
        this.storage.readNbt(nbt);
    }

    public WritableStackStorage getInputStorage(class_2350 direction) {
        return this.storage.inputStorage;
    }

    public WritableSingleFluidStorage getOutputStorage(class_2350 direction) {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)ItemMincerBlock.field_11177);
        return facing == direction ? this.storage.outputStorage : null;
    }

    public FluidPump getPump(class_2350 direction) {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)ItemMincerBlock.field_11177);
        return facing == direction ? this.pump : null;
    }

    @Override
    public MotorisedBlock.Diagnostics getDiagnostics() {
        return MotorisedBlock.Diagnostics.insufficientPower(false, this.power, 0.0f);
    }

    public static enum State {
        IDLE,
        PROCESSING;

    }
}

