/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.live_machine.process;

import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.LivingMachineBlockEntity;
import com.neep.neepmeat.api.live_machine.Process;
import com.neep.neepmeat.machine.live_machine.LivingMachineComponents;
import com.neep.neepmeat.machine.reactor.block.entity.DisruptorPortBlockEntity;
import com.neep.neepmeat.machine.reactor.block.entity.DisruptorSegmentBlockEntity;
import com.neep.neepmeat.machine.reactor.block.entity.ReactionCoreBlockEntity;
import com.neep.neepmeat.machine.reactor.disruptor.DisruptorNeedle;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class DisruptorProcess
implements Process {
    private static final List<ComponentType<?>> REQUIRED = List.of(LivingMachineComponents.DISRUPTOR_SEGMENT, LivingMachineComponents.DISRUPTOR_PORT, LivingMachineComponents.DISRUPTOR_NEEDLE);

    @Override
    public void serverTick(LivingMachineBlockEntity be) {
        be.withComponents(LivingMachineComponents.DISRUPTOR_SEGMENT, LivingMachineComponents.DISRUPTOR_PORT, LivingMachineComponents.DISRUPTOR_NEEDLE).ifPresent(r -> {
            ReactionCoreBlockEntity core;
            Collection segments = r.t1();
            DisruptorPortBlockEntity port = (DisruptorPortBlockEntity)r.t2().iterator().next();
            Collection<DisruptorNeedle> needles = r.t3();
            class_1937 world = be.method_10997();
            if (world.method_8510() % 20L == 0L) {
                port.setCore(null);
                ReactionCoreBlockEntity core2 = this.updateOrganism(world, needles);
                if (core2 != null) {
                    port.setCore(core2);
                }
            }
            int disruption = port.getDisruption();
            if (world.method_8510() % 3L == 0L) {
                for (DisruptorSegmentBlockEntity segment : segments) {
                    segment.setDisruption(disruption);
                }
            }
            if ((core = port.getCore()) != null) {
                float maxIncrease = be.getPower() * 100.0f;
                core.setDisruptorParams(disruption, maxIncrease);
            }
        });
    }

    @Override
    public void onStart(LivingMachineBlockEntity be) {
        be.withComponents(LivingMachineComponents.DISRUPTOR_NEEDLE).ifPresent(r -> r.t1().forEach(needle -> needle.updateState(true)));
    }

    @Override
    public void onStop(LivingMachineBlockEntity be) {
        be.withComponents(LivingMachineComponents.DISRUPTOR_PORT, LivingMachineComponents.DISRUPTOR_NEEDLE).ifPresent(r -> {
            ((DisruptorPortBlockEntity)r.t1().iterator().next()).setCore(null);
            r.t2().forEach(needle -> needle.updateState(false));
        });
    }

    @Nullable
    private ReactionCoreBlockEntity updateOrganism(class_1937 world, Collection<DisruptorNeedle> needles) {
        for (DisruptorNeedle needle : needles) {
            ReactionCoreBlockEntity found = needle.findCore();
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public List<ComponentType<?>> getRequired() {
        return REQUIRED;
    }

    @Override
    public class_2561 getName() {
        return NeepMeat.translationKey("process", "disruptor");
    }
}

