/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.live_machine.process;

import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.LivingMachineBlockEntity;
import com.neep.neepmeat.api.live_machine.Process;
import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.machine.live_machine.LivingMachineComponents;
import com.neep.neepmeat.machine.live_machine.block.entity.LargeCompressorBlockEntity;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2561;

public class LargeCompressorProcess
implements Process {
    private static final List<ComponentType<?>> REQUIRED = List.of(LivingMachineComponents.MOTOR_PORT, LivingMachineComponents.LARGE_COMPRESSOR);

    @Override
    public void serverTick(LivingMachineBlockEntity be) {
        be.withComponents(LivingMachineComponents.MOTOR_PORT, LivingMachineComponents.LARGE_COMPRESSOR).ifPresent(r -> {
            Collection motors = r.t1();
            Collection compressors = r.t2();
            LargeCompressorBlockEntity compressor = (LargeCompressorBlockEntity)compressors.iterator().next();
            float progressIncrement = be.getProgressIncrement();
            long droplets = (long)(progressIncrement * (float)((Integer)NeepMeat.CONFIG.largeCompressor.powerToDroplets.getRealValue()).intValue());
            try (Transaction transaction = Transaction.openOuter();){
                compressor.getOutputStorage().insert((Object)NMFluids.COMPRESSED_AIR.variant(), droplets, (TransactionContext)transaction);
                transaction.commit();
            }
        });
    }

    @Override
    public List<ComponentType<?>> getRequired() {
        return REQUIRED;
    }

    @Override
    public class_2561 getName() {
        return NeepMeat.translationKey("process", "large_compressor");
    }
}

