/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.live_machine.process;

import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.LivingMachineBlockEntity;
import com.neep.neepmeat.api.live_machine.Process;
import com.neep.neepmeat.machine.live_machine.LivingMachineComponents;
import com.neep.neepmeat.machine.live_machine.block.entity.LargeTrommelBlockEntity;
import com.neep.neepmeat.machine.live_machine.component.ItemOutputComponent;
import java.util.Collection;
import java.util.List;
import java.util.stream.StreamSupport;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2561;

public class LargeTrommelProcess
implements Process {
    @Override
    public void serverTick(LivingMachineBlockEntity be) {
        be.withComponents(LivingMachineComponents.LARGE_TROMMEL, LivingMachineComponents.FLUID_INPUT, LivingMachineComponents.FLUID_OUTPUT, LivingMachineComponents.ITEM_OUTPUT, LivingMachineComponents.MOTOR_PORT).ifPresent(result -> {
            Collection trommels = result.t1();
            Collection fluidInputs = result.t2();
            Collection fluidOutputs = result.t3();
            Collection itemOutputs = result.t4();
            if ((double)be.getPower() < 0.1) {
                return;
            }
            float progressIncrement = be.getProgressIncrement() * 2.0f / (float)trommels.size();
            try (Transaction transaction = Transaction.openOuter();){
                for (LargeTrommelBlockEntity trommel : trommels) {
                    LargeTrommelBlockEntity.InputSlot slot = trommel.getStorage();
                    if (slot.isResourceBlank()) {
                        try (Transaction inner = transaction.openNested();){
                            long extracted;
                            StorageView input;
                            FluidVariant variant;
                            long inserted;
                            List inputViews = fluidInputs.stream().map(c -> c.getStorage(null)).flatMap(s -> StreamSupport.stream(s.nonEmptyViews().spliterator(), false)).toList();
                            if (!inputViews.isEmpty() && (inserted = slot.insert(variant = (FluidVariant)(input = (StorageView)inputViews.get(be.getRandom().method_43048(inputViews.size()))).getResource(), extracted = input.extract((Object)variant, 9000L, (TransactionContext)inner), (TransactionContext)inner)) == 9000L && slot.getAmount() == 9000L) {
                                inner.commit();
                            }
                        }
                    }
                    if (slot.isResourceBlank()) continue;
                    CombinedStorage fluidOutput = new CombinedStorage(fluidOutputs.stream().map(c -> c.getStorage(null)).toList());
                    CombinedStorage itemOutput = new CombinedStorage(itemOutputs.stream().map(ItemOutputComponent::getInternalStorage).toList());
                    slot.tick(progressIncrement, (Storage<FluidVariant>)fluidOutput, (Storage<ItemVariant>)itemOutput, (TransactionContext)transaction);
                }
                transaction.commit();
            }
        });
    }

    @Override
    public List<ComponentType<?>> getRequired() {
        return List.of(LivingMachineComponents.LARGE_TROMMEL, LivingMachineComponents.FLUID_INPUT, LivingMachineComponents.FLUID_OUTPUT, LivingMachineComponents.ITEM_OUTPUT, LivingMachineComponents.MOTOR_PORT);
    }

    @Override
    public class_2561 getName() {
        return NeepMeat.translationKey("process", "trommel");
    }
}

