/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.live_machine.process;

import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.LivingMachineBlockEntity;
import com.neep.neepmeat.api.live_machine.Process;
import com.neep.neepmeat.api.processing.MeatFluidUtil;
import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.machine.live_machine.LivingMachineComponents;
import com.neep.neepmeat.machine.live_machine.component.MetaboliserSegmentComponent;
import com.neep.neepmeat.machine.power_flower.PowerFlowerControllerBlockEntity;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2561;

public class MetaboliserProcess
implements Process {
    private static final List<ComponentType<?>> REQUIRED = List.of(LivingMachineComponents.STOMACH, LivingMachineComponents.METABOLISER_SEGMENT);

    public static PowerFlowerControllerBlockEntity.FoodEnergyEntry foodEnergy(FluidVariant fluid) {
        if (fluid.isOf((Object)NMFluids.STILL_MEAT)) {
            return new PowerFlowerControllerBlockEntity.FoodEnergyEntry(40, 1);
        }
        if (fluid.isOf((Object)NMFluids.STILL_FEED)) {
            return new PowerFlowerControllerBlockEntity.FoodEnergyEntry(60, 1);
        }
        if (fluid.isOf((Object)NMFluids.STILL_C_MEAT)) {
            return new PowerFlowerControllerBlockEntity.FoodEnergyEntry(1 + 9 * (int)Math.ceil(MeatFluidUtil.getHunger(fluid)), 1);
        }
        return PowerFlowerControllerBlockEntity.NONE;
    }

    @Override
    public void serverTick(LivingMachineBlockEntity be) {
        be.withComponents(LivingMachineComponents.STOMACH, LivingMachineComponents.METABOLISER_SEGMENT).ifPresent(result -> {
            Collection segments = result.t2();
            long energyProduced = 0L;
            long toConsume = (long)segments.size() * 4L;
            try (Transaction transaction = Transaction.openOuter();){
                for (StorageView view : be.getCombinedFluidInput().nonEmptyViews()) {
                    FluidVariant resource = (FluidVariant)view.getResource();
                    PowerFlowerControllerBlockEntity.FoodEnergyEntry entry = MetaboliserProcess.foodEnergy((FluidVariant)view.getResource());
                    if (entry == PowerFlowerControllerBlockEntity.NONE) continue;
                    long adjusted = toConsume * (long)entry.consume();
                    long extracted = view.extract((Object)resource, adjusted, (TransactionContext)transaction);
                    toConsume -= (extracted /= (long)entry.consume());
                    energyProduced += (long)entry.energy() * extracted;
                }
                for (MetaboliserSegmentComponent segment : segments) {
                    segment.setOutputEnergy((long)((double)energyProduced * 1.5 / (double)segments.size()));
                }
                transaction.commit();
            }
        });
    }

    @Override
    public List<ComponentType<?>> getRequired() {
        return REQUIRED;
    }

    @Override
    public class_2561 getName() {
        return NeepMeat.translationKey("process", "metaboliser");
    }
}

