/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.living_rock;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.FluidPump;
import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.machine.living_rock.VerrucousStoneBlock;
import com.neep.neepmeat.machine.living_rock.VerrucousStonePortBlock;
import com.neep.neepmeat.transport.api.AutoEjector;
import com.neep.neepmeat.transport.fluid_network.node.AcceptorModes;
import java.util.ArrayDeque;
import java.util.HashSet;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class VerrucousStonePortBlockEntity
extends SyncableBlockEntity {
    private final WritableSingleFluidStorage storage = new WritableSingleFluidStorage(324000L){

        protected boolean canInsert(FluidVariant variant) {
            return variant.isOf((Object)NMFluids.STILL_ETHEREAL_FUEL);
        }
    };
    private final FluidPump pump = FluidPump.of(-1.0f, () -> AcceptorModes.PUSH);
    private final AutoEjector<FluidVariant> ejector = this.addListener(AutoEjector.simpleFluid(() -> (class_2350)state.method_11654((class_2769)VerrucousStonePortBlock.field_10927), this, (Storage<FluidVariant>)this.storage, this.pump));
    private int structures = 1;
    private int ports = 1;

    public VerrucousStonePortBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void serverTick() {
        if (this.field_11863.method_8510() % 80L == 0L) {
            this.updateStructure(this.field_11867);
        }
        this.createFluid();
        this.ejector.tick(null);
    }

    private void createFluid() {
        try (Transaction transaction = Transaction.openOuter();){
            int passivePower = (Integer)NeepMeat.CONFIG.verrucousStone.passiveCoefficient.getRealValue() * this.structures / Math.max(1, this.ports);
            long passiveAmount = PowerUtils.absToAmount((class_3611)NMFluids.STILL_ETHEREAL_FUEL, passivePower);
            if (passiveAmount > 0L) {
                this.storage.insert(FluidVariant.of((class_3611)NMFluids.STILL_ETHEREAL_FUEL), passiveAmount, (TransactionContext)transaction);
                transaction.commit();
            }
        }
    }

    private void updateStructure(class_2338 origin) {
        this.structures = 1;
        this.ports = 1;
        ArrayDeque<class_2338> posQueue = new ArrayDeque<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        posQueue.add(origin);
        visited.add(origin);
        while (!posQueue.isEmpty()) {
            class_2338 current = (class_2338)posQueue.poll();
            for (class_2350 direction : class_2350.values()) {
                class_2338 offset = current.method_10093(direction);
                if (visited.contains(offset)) continue;
                visited.add(offset);
                class_2680 offsetState = this.field_11863.method_8320(offset);
                class_2248 offsetBlock = offsetState.method_26204();
                if (offsetBlock instanceof VerrucousStoneBlock) {
                    ++this.structures;
                    posQueue.add(offset);
                    continue;
                }
                if (!(offsetBlock instanceof VerrucousStonePortBlock)) continue;
                ++this.ports;
                ++this.structures;
                posQueue.add(offset);
            }
        }
    }

    @Nullable
    public Storage<FluidVariant> getStorage(@Nullable class_2350 direction) {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)VerrucousStonePortBlock.field_10927);
        if (direction == null || direction == facing) {
            return this.storage;
        }
        return null;
    }

    @Nullable
    public FluidPump getPump(@Nullable class_2350 direction) {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)VerrucousStonePortBlock.field_10927);
        if (direction == null || direction == facing) {
            return this.pump;
        }
        return null;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.storage.writeNbt(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.storage.readNbt(nbt);
    }
}

