/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.mincer;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.api.FluidPump;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.init.NMDamageSources;
import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.init.NMParticles;
import com.neep.neepmeat.machine.death_blades.DeathBladesBlockEntity;
import com.neep.neepmeat.machine.mincer.MincerBlock;
import com.neep.neepmeat.machine.motor.MotorEntity;
import com.neep.neepmeat.transport.fluid_network.node.AcceptorModes;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1282;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class MincerBlockEnity
extends SyncableBlockEntity
implements MotorisedBlock,
MotorisedBlock.DiagnosticsProvider {
    private int damageTime;
    protected boolean running;
    protected float power = 0.0f;
    @Nullable
    private class_1309 captured;
    protected WritableSingleFluidStorage fluidStorage = new WritableSingleFluidStorage(162000L, this::method_5431){

        public boolean supportsInsertion() {
            return false;
        }
    };

    public MincerBlockEnity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public MincerBlockEnity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.MINCER, pos, state);
    }

    public void serverTick(class_1937 world) {
        if (this.running) {
            this.processEntity(world);
        }
    }

    protected void processEntity(class_1937 world) {
        this.damageTime = Math.max(0, this.damageTime - 1);
        class_238 catchmentBox = new class_238((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (double)(this.field_11867.method_10263() + 1), (double)this.field_11867.method_10264() + 3.5, (double)(this.field_11867.method_10260() + 1));
        if (this.captured == null || !catchmentBox.method_1006(this.captured.method_19538())) {
            class_1309 entity;
            List entities = world.method_18023(class_5575.method_31795(class_1309.class), catchmentBox, e -> e instanceof class_1308 || e instanceof class_1657);
            if (!entities.isEmpty() && !(entity = (class_1309)entities.get(0)).method_29504()) {
                this.captured = entity;
            }
        } else {
            if (world.method_8409().method_43048(9) == 1) {
                ((class_3218)world).method_14199((class_2394)class_2398.field_11239, (double)this.method_11016().method_10263() + 0.5, (double)(this.method_11016().method_10264() + 2), (double)this.method_11016().method_10260() + 0.5, 1, 0.1, 0.0, 0.2, 0.01);
            }
            this.captured.method_23327((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5 + (double)this.getYOffset(this.captured) * 1.4, (double)this.field_11867.method_10260() + 0.5);
            this.captured.method_36456(class_3532.method_15393((float)(this.captured.method_36454() + 10.0f)));
            this.captured.field_6017 = 0.0f;
            class_243 vel = this.captured.method_18798();
            this.captured.method_18800(vel.field_1352, 0.0, vel.field_1350);
            if (this.damageTime == 0) {
                if (this.damageEntity((class_3218)world, this.captured)) {
                    this.captured = null;
                }
                this.damageTime = 10;
            }
        }
    }

    protected boolean damageEntity(class_3218 world, class_1309 entity) {
        class_1282 damageSource = world.method_48963().method_48795(NMDamageSources.MINCER);
        float damageAmount = 20.0f * this.power;
        if (entity.method_6032() <= damageAmount) {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                player.method_5643(damageSource, Float.MAX_VALUE);
            } else {
                entity.method_31472();
            }
            MincerBlockEnity.insertFluidFromEntity(this, entity);
            world.method_14199((class_2394)NMParticles.MEAT_FOUNTAIN, (double)this.field_11867.method_10263() + 0.5, (double)((float)(this.field_11867.method_10264() + 1) + 0.875f), (double)this.field_11867.method_10260() + 0.5, 20, 0.4, 0.4, 0.4, 0.01);
            return true;
        }
        entity.method_5643(damageSource, damageAmount);
        return false;
    }

    protected static void insertFluidFromEntity(MincerBlockEnity be, class_1309 entity) {
        try (Transaction transaction = Transaction.openOuter();){
            be.getFluidStorage(null).insert(FluidVariant.of((class_3611)NMFluids.STILL_TISSUE_SLURRY), DeathBladesBlockEntity.getEntityAmount(entity), (TransactionContext)transaction);
            transaction.commit();
        }
    }

    public void clientTickRunning(class_1937 world) {
        class_5819 random = world.field_9229;
        if (random.method_43057() < 0.1f) {
            for (int i = 0; i < random.method_43048(2) + 2; ++i) {
                world.method_8406((class_2394)class_2398.field_11251, (double)this.field_11867.method_10263() + 0.5 + random.method_43058() / 4.0 * (double)(random.method_43056() ? 1 : -1), (double)this.field_11867.method_10264() + 1.0 + 0.875, (double)this.field_11867.method_10260() + 0.5 + random.method_43058() / 4.0 * (double)(random.method_43056() ? 1 : -1), 0.0, 0.005, 0.0);
            }
        }
    }

    protected float getYOffset(class_1309 entity) {
        return entity.method_6032() / entity.method_6063();
    }

    public WritableSingleFluidStorage getFluidStorage(class_2350 direction) {
        return this.fluidStorage;
    }

    public FluidPump getFluidPump(class_2350 direction) {
        return FluidPump.of(-0.5f, () -> AcceptorModes.PUSH);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("damageTime", this.damageTime);
        nbt.method_10556("running", this.running);
        nbt.method_10548("power", this.power);
        this.fluidStorage.toNbt(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.damageTime = nbt.method_10550("damageTime");
        this.power = nbt.method_10583("power");
        this.running = nbt.method_10577("running");
        this.fluidStorage.readNbt(nbt);
    }

    @Override
    public boolean motorTick(MotorEntity motor) {
        return false;
    }

    protected void updateBlockstate() {
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        if ((Boolean)state.method_11654((class_2769)MincerBlock.RUNNING) != this.running) {
            this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)MincerBlock.RUNNING, (Comparable)Boolean.valueOf(this.running)));
        }
    }

    @Override
    public void setInputPower(float power) {
        this.power = power;
        this.running = (double)power >= 0.1;
        this.updateBlockstate();
        this.sync();
    }

    @Override
    public void onMotorRemoved() {
        this.running = false;
        this.updateBlockstate();
    }

    @Override
    public MotorisedBlock.Diagnostics getDiagnostics() {
        return MotorisedBlock.Diagnostics.insufficientPower(!this.running, this.power, 0.1f);
    }
}

