/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.mixer;

import com.neep.meatlib.recipe.ImplementedRecipe;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.api.storage.WritableStackStorage;
import com.neep.neepmeat.machine.mixer.MixerBlockEntity;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ExtractionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class MixerStorage
implements ImplementedRecipe.DummyInventory {
    protected MixerBlockEntity parent;
    protected WritableSingleFluidStorage fluidInput1;
    protected WritableSingleFluidStorage fluidInput2;
    protected WritableSingleFluidStorage fluidOutput;
    protected Storage<FluidVariant> extractionOnlyOutput;
    protected WritableStackStorage itemInput;
    public FluidVariant displayInput1 = FluidVariant.blank();
    public FluidVariant displayInput2 = FluidVariant.blank();

    public MixerStorage(MixerBlockEntity parent) {
        this.parent = parent;
        Runnable callback = parent::sync;
        this.fluidInput1 = new WritableSingleFluidStorage(81000L, callback);
        this.fluidInput2 = new WritableSingleFluidStorage(81000L, callback);
        this.itemInput = new WritableStackStorage(parent::sync);
        this.fluidOutput = new WritableSingleFluidStorage(162000L, callback);
        this.extractionOnlyOutput = new ExtractionOnlyStorage<FluidVariant>(){

            public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
                return MixerStorage.this.fluidOutput.extract((TransferVariant)resource, maxAmount, transaction);
            }

            public Iterator<StorageView<FluidVariant>> iterator() {
                return MixerStorage.this.fluidOutput.iterator();
            }
        };
    }

    public Storage<FluidVariant> getInputStorages() {
        List<Storage<FluidVariant>> storages = this.parent.getAdjacentStorages();
        return new CombinedStorage(storages);
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10566("displayInput1", (class_2520)this.displayInput1.toNbt());
        nbt.method_10566("displayInput2", (class_2520)this.displayInput2.toNbt());
        class_2487 input1 = new class_2487();
        this.fluidInput1.toNbt(input1);
        nbt.method_10566("input_1", (class_2520)input1);
        class_2487 input2 = new class_2487();
        this.fluidInput2.toNbt(input2);
        nbt.method_10566("input_2", (class_2520)input2);
        class_2487 itemNbt = new class_2487();
        this.itemInput.writeNbt(itemNbt);
        nbt.method_10566("item_input", (class_2520)itemNbt);
        class_2487 output = new class_2487();
        this.fluidOutput.toNbt(output);
        nbt.method_10566("output", (class_2520)output);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.displayInput1 = FluidVariant.fromNbt((class_2487)nbt.method_10562("displayInput1"));
        this.displayInput2 = FluidVariant.fromNbt((class_2487)nbt.method_10562("displayInput2"));
        class_2487 input1 = nbt.method_10562("input_1");
        this.fluidInput1.readNbt(input1);
        class_2487 input2 = nbt.method_10562("input_2");
        this.fluidInput2.readNbt(input2);
        class_2487 itemNbt = nbt.method_10562("item_input");
        this.itemInput.readNbt(itemNbt);
        class_2487 output = nbt.method_10562("output");
        this.fluidOutput.readNbt(output);
    }

    public WritableStackStorage getItemInput() {
        return this.itemInput;
    }

    public Storage<FluidVariant> getFluidOutput() {
        return this.fluidOutput;
    }

    public Storage<FluidVariant> getExtractOutput() {
        return this.extractionOnlyOutput;
    }

    private static class FluidOutputStorage
    extends WritableSingleFluidStorage {
        public boolean locked = true;

        public FluidOutputStorage(long capacity, Runnable finalCallback) {
            super(capacity, finalCallback);
        }

        protected boolean canInsert(FluidVariant variant) {
            return !this.locked && super.canInsert((TransferVariant)variant);
        }
    }
}

