/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.motor;

import com.neep.meatlib.block.BaseFacingBlock;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.machine.motor.LiquidFuelMachine;
import com.neep.neepmeat.machine.motor.MotorEntity;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class MotorBlockEntity
extends LiquidFuelMachine
implements MotorEntity {
    public float rotorSpeed = 1.0f;
    public float currentSpeed = 0.0f;
    public float angle;
    protected float outputPower = 0.0f;
    protected float loadTorque;
    @Nullable
    protected BlockApiCache<MotorisedBlock, Void> cache = null;
    @Nullable
    private MotorisedBlock lastMotorised;

    public MotorBlockEntity(class_2591<MotorBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void method_31664(class_2680 state) {
        super.method_31664(state);
        this.cache = null;
    }

    public void tick() {
        MotorisedBlock motorised;
        if (this.cache == null) {
            class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)BaseFacingBlock.field_10927);
            this.cache = BlockApiCache.create(MotorisedBlock.LOOKUP, (class_3218)((class_3218)this.field_11863), (class_2338)this.field_11867.method_10093(facing));
        }
        if ((motorised = (MotorisedBlock)this.cache.find(null)) != null) {
            if (motorised.getLoadTorque() != this.loadTorque) {
                this.loadTorque = motorised.getLoadTorque();
                this.sync();
            }
            if (motorised != this.lastMotorised) {
                this.lastMotorised = motorised;
                this.onPowerChange();
            }
            motorised.motorTick(this);
        } else {
            this.lastMotorised = null;
        }
        try (Transaction transaction = Transaction.openOuter();){
            long extracted = this.extractEnergy(this.maxPower(), (TransactionContext)transaction);
            float newPower = extracted > 0L ? (float)PowerUtils.absoluteToPerUnit(extracted) : 0.0f;
            if (newPower != this.outputPower) {
                this.outputPower = newPower;
                this.onPowerChange();
            }
            transaction.commit();
        }
    }

    protected void onPowerChange() {
        MotorisedBlock motorised = this.getConnectedBlock();
        if (motorised != null) {
            motorised.setInputPower((float)this.getMechPUPower());
        }
        this.sync();
    }

    @Override
    public float getRotorAngle() {
        return this.angle;
    }

    @Override
    public double getMechPUPower() {
        return this.outputPower;
    }

    @Override
    public MotorisedBlock getConnectedBlock() {
        return this.cache != null ? (MotorisedBlock)this.cache.find(null) : null;
    }

    @Override
    public float getSpeed() {
        double P = PowerUtils.perUnitToAbsWatt(this.getMechPUPower());
        return (float)(P / (double)(this.loadTorque != 0.0f ? this.loadTorque : 300.0f));
    }

    @Override
    protected long maxPower() {
        return ((Integer)NeepMeat.CONFIG.motors.basicMotorMaxPower.getRealValue()).intValue();
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10548("loadTorque", this.loadTorque);
        nbt.method_10548("influx", this.outputPower);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.loadTorque = nbt.method_10583("loadTorque");
        this.outputPower = nbt.method_10583("influx");
    }
}

