/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.stirling_engine;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.api.storage.LazyBlockApiCache;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.machine.motor.MotorEntity;
import com.neep.neepmeat.machine.stirling_engine.StirlingEngineBlock;
import com.neep.neepmeat.machine.stirling_engine.StirlingEngineStorage;
import com.neep.neepmeat.screen_handler.StirlingEngineScreenHandler;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2363;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;

public class StirlingEngineBlockEntity
extends SyncableBlockEntity
implements class_3908,
MotorEntity {
    protected StirlingEngineStorage storage;
    public static final int ENERGY_CAPACITY = 5000;
    public static final float MAX_PU = 0.08f;
    public float angle;
    protected float energyStored;
    protected long outputPower;
    protected int burnTime;
    protected int fuelTime;
    protected LazyBlockApiCache<MotorisedBlock, Void> cache;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> StirlingEngineBlockEntity.this.burnTime;
                case 1 -> StirlingEngineBlockEntity.this.fuelTime;
                case 2 -> (int)StirlingEngineBlockEntity.this.energyStored;
                case 3 -> (int)StirlingEngineBlockEntity.this.outputPower;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
        }

        public int method_17389() {
            return 4;
        }
    };

    public StirlingEngineBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.storage = new StirlingEngineStorage(this);
        this.updateCache();
    }

    public StirlingEngineBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.STIRLING_ENGINE, pos, state);
    }

    @Override
    public void method_31664(class_2680 state) {
        super.method_31664(state);
        this.updateCache();
    }

    private void updateCache() {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)StirlingEngineBlock.field_10927);
        this.cache = LazyBlockApiCache.of(MotorisedBlock.LOOKUP, this.field_11867.method_10093(facing), () -> ((StirlingEngineBlockEntity)this).method_10997(), () -> null);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.storage.writeNbt(nbt);
        nbt.method_10569("burn_time", this.burnTime);
        nbt.method_10569("fuel_time", this.fuelTime);
        nbt.method_10548("energy", this.energyStored);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.storage.readNbt(nbt);
        this.burnTime = nbt.method_10550("burn_time");
        this.fuelTime = nbt.method_10550("fuel_time");
        this.energyStored = nbt.method_10583("energy");
    }

    public void serverTick() {
        this.burnTime = Math.max(0, this.burnTime - 1);
        float newThingyStored = this.energyStored;
        if (this.isBurning()) {
            newThingyStored = Math.min(5000.0f, this.energyStored + 20.0f);
        }
        if (this.burnTime == 0) {
            int time = this.storage.decrementFuel();
            if (time > 0) {
                this.burnTime = time;
                this.fuelTime = time;
            }
            this.updateBurning();
        }
        long prevOutputPower = this.outputPower;
        this.outputPower = (long)class_3532.method_15363((float)(this.energyStored / 5000.0f * 80.0f), (float)0.0f, (float)this.energyStored);
        MotorisedBlock motorised = this.cache.find();
        if (motorised != null) {
            if (prevOutputPower != this.outputPower) {
                motorised.setInputPower((float)this.getMechPUPower());
            }
            newThingyStored = Math.max(0.0f, newThingyStored - (float)this.outputPower);
            motorised.motorTick(this);
        }
        if (newThingyStored != this.energyStored) {
            this.energyStored = newThingyStored;
            this.sync();
        }
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    protected void updateBurning() {
        class_2680 state = this.method_11010();
        state = (class_2680)state.method_11657((class_2769)class_2363.field_11105, (Comparable)Boolean.valueOf(this.isBurning()));
        this.method_10997().method_8652(this.field_11867, state, 3);
    }

    public StirlingEngineStorage getStorage() {
        return this.storage;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.neepmeat.stirling_engine");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new StirlingEngineScreenHandler(syncId, inv, (class_1263)this.storage.inventory, this.propertyDelegate);
    }

    public static float energyToSpeed(float energy) {
        float w1 = (float)Math.sqrt(2.0f * energy / 40.0f) / 20.0f;
        return (float)((double)(w1 * 180.0f) / Math.PI);
    }

    @Override
    public float getRotorAngle() {
        return this.angle;
    }

    @Override
    public float getSpeed() {
        return StirlingEngineBlockEntity.energyToSpeed(this.energyStored);
    }

    @Override
    public double getMechPUPower() {
        return (double)this.outputPower / (double)PowerUtils.BASE_POWER;
    }

    @Override
    public MotorisedBlock getConnectedBlock() {
        return this.cache != null ? this.cache.find() : null;
    }
}

