/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc;

import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.plc.instruction.CallInstruction;
import com.neep.neepmeat.api.plc.instruction.PredicatedInstructionBuilder;
import com.neep.neepmeat.api.plc.instruction.SimpleInstructionProvider;
import com.neep.neepmeat.api.plc.instruction.SimplerInstructionProvider;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.parser.CallInstructionParser;
import com.neep.neepmeat.neepasm.compiler.parser.InstructionParser;
import com.neep.neepmeat.neepasm.compiler.parser.JumpInstructionParser;
import com.neep.neepmeat.neepasm.program.Label;
import com.neep.neepmeat.plc.ArgumentPredicates;
import com.neep.neepmeat.plc.SingletonInstructions;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.BIFInstruction;
import com.neep.neepmeat.plc.instruction.BITInstruction;
import com.neep.neepmeat.plc.instruction.CombineInstruction;
import com.neep.neepmeat.plc.instruction.CountInstruction;
import com.neep.neepmeat.plc.instruction.DelayInstruction;
import com.neep.neepmeat.plc.instruction.EmitRedstoneInstruction;
import com.neep.neepmeat.plc.instruction.ExecInstruction;
import com.neep.neepmeat.plc.instruction.ImplantInstruction;
import com.neep.neepmeat.plc.instruction.InjectInstruction;
import com.neep.neepmeat.plc.instruction.Instruction;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.InterruptHandlerInstruction;
import com.neep.neepmeat.plc.instruction.JumpInstruction;
import com.neep.neepmeat.plc.instruction.MoveInstruction;
import com.neep.neepmeat.plc.instruction.NeepBusReadInstruction;
import com.neep.neepmeat.plc.instruction.NeepBusWriteInstruction;
import com.neep.neepmeat.plc.instruction.PushInstruction;
import com.neep.neepmeat.plc.instruction.ReadRedstoneInstruction;
import com.neep.neepmeat.plc.instruction.RemoveInstruction;
import com.neep.neepmeat.plc.instruction.RequestItemInstruction;
import com.neep.neepmeat.plc.instruction.RestartInstruction;
import com.neep.neepmeat.plc.instruction.ReturnInstruction;
import com.neep.neepmeat.plc.instruction.RobotInstruction;
import com.neep.neepmeat.plc.instruction.RouteItemInstruction;
import com.neep.neepmeat.plc.instruction.SHLInstruction;
import com.neep.neepmeat.plc.instruction.SHRInstruction;
import com.neep.neepmeat.plc.instruction.SayInstruction;
import com.neep.neepmeat.plc.instruction.SimpleInstruction;
import com.neep.neepmeat.plc.instruction.WaitForInterruptInstruction;
import com.neep.neepmeat.plc.instruction.WaitRedstoneInstruction;
import com.neep.neepmeat.plc.instruction.memory.ExtFetchInstruction;
import com.neep.neepmeat.plc.instruction.memory.ExtStoreInstruction;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class Instructions {
    public static final Map<String, InstructionProvider> REGISTRY = new HashMap<String, InstructionProvider>();
    public static final InstructionProvider END = Instructions.registerSingleton("end", Instruction.end());
    public static final InstructionProvider RESTART = Instructions.registerSingleton("restart", RestartInstruction.INSTANCE);
    public static final InstructionProvider PC = Instructions.registerSingleton("pc", SingletonInstructions.PC);
    public static final SimplerInstructionProvider RET = Instructions.registerSingleton("ret", ReturnInstruction.INSTANCE);
    public static final SimplerInstructionProvider CALL = Instructions.register(new SimplerInstructionProvider(CallInstruction::new, new CallInstructionParser(), "CALL"));
    public static final SimplerInstructionProvider IHANDLER = Instructions.register(new SimplerInstructionProvider(InterruptHandlerInstruction::new, InterruptHandlerInstruction::parser, "IHANDLER"));
    public static final SimplerInstructionProvider IWAIT = Instructions.registerSingleton("iwait", WaitForInterruptInstruction.INSTANCE);
    public static final SimplerInstructionProvider ICLEAR = Instructions.registerSingleton("iclear", () -> ICLEAR, WaitForInterruptInstruction::clearInterrupts);
    public static final SimplerInstructionProvider IDISABLE = Instructions.registerSingleton("idisable", () -> IDISABLE, WaitForInterruptInstruction::disableInterrupts);
    public static final SimplerInstructionProvider IENABLE = Instructions.registerSingleton("ienable", () -> IENABLE, WaitForInterruptInstruction::enableInterrupts);
    public static final SimplerInstructionProvider PUSH = Instructions.register(new SimplerInstructionProvider(PushInstruction::new, new PushInstruction.Parser(), "PUSH"));
    public static final SimplerInstructionProvider POP = Instructions.registerSingleton("pop", SingletonInstructions.POP);
    public static final SimplerInstructionProvider SWAP = Instructions.registerSingleton("swp", SingletonInstructions.SWAP);
    public static final SimplerInstructionProvider DUP = Instructions.registerSingleton("dup", SingletonInstructions.DUP);
    public static final SimplerInstructionProvider OVER = Instructions.registerSingleton("over", SingletonInstructions.OVER);
    public static final SimplerInstructionProvider ROT = Instructions.registerSingleton("rot", SingletonInstructions.ROT);
    public static final SimplerInstructionProvider PICK = Instructions.registerSingleton("pick", SingletonInstructions.PICK);
    public static final SimplerInstructionProvider TO_RET = Instructions.registerSingleton("rto", SingletonInstructions.TO_RET);
    public static final SimplerInstructionProvider FROM_RET = Instructions.registerSingleton("rfrom", SingletonInstructions.FROM_RET);
    public static final SimplerInstructionProvider RET_FETCH = Instructions.registerSingleton("rfetch", SingletonInstructions.RET_FETCH);
    public static final SimplerInstructionProvider RET_ADD = Instructions.registerSingleton("radd", SingletonInstructions.RET_ADD);
    public static final SimplerInstructionProvider RET_EQ = Instructions.registerSingleton("req", SingletonInstructions.RET_EQ);
    public static final InstructionProvider FREE = Instructions.registerSingleton("free", SingletonInstructions.FREE);
    public static final InstructionProvider STORE = Instructions.registerSingleton("store", SingletonInstructions.STORE);
    public static final InstructionProvider ALLOT = Instructions.registerSingleton("allot", SingletonInstructions.ALLOT);
    public static final InstructionProvider FETCH = Instructions.registerSingleton("fetch", SingletonInstructions.FETCH);
    public static final InstructionProvider EXTFETCH = Instructions.register(new SimplerInstructionProvider(ExtFetchInstruction::new, ExtFetchInstruction::parser, "EXTFETCH"));
    public static final InstructionProvider EXTSTORE = Instructions.register(new SimplerInstructionProvider(ExtStoreInstruction::new, ExtStoreInstruction::parser, "EXTSTORE"));
    public static final InstructionProvider FILL = Instructions.registerSingleton("fill", SingletonInstructions.FILL);
    public static final SimplerInstructionProvider DELAY = Instructions.register(new SimplerInstructionProvider(DelayInstruction::new, DelayInstruction::parse, "DELAY"));
    public static final SimplerInstructionProvider EQ = Instructions.registerSingleton("eq", SingletonInstructions.EQ);
    public static final SimplerInstructionProvider LT = Instructions.registerSingleton("lt", SingletonInstructions.LT);
    public static final SimplerInstructionProvider LTEQ = Instructions.registerSingleton("lteq", SingletonInstructions.LTEQ);
    public static final SimplerInstructionProvider GT = Instructions.registerSingleton("gt", SingletonInstructions.GT);
    public static final SimplerInstructionProvider GTEQ = Instructions.registerSingleton("gteq", SingletonInstructions.GTEQ);
    public static final SimplerInstructionProvider INC = Instructions.registerSingleton("inc", SingletonInstructions.INC);
    public static final SimplerInstructionProvider DEC = Instructions.registerSingleton("dec", SingletonInstructions.DEC);
    public static final SimplerInstructionProvider NEG = Instructions.registerSingleton("neg", SingletonInstructions.NEG);
    public static final SimplerInstructionProvider ADD = Instructions.registerSingleton("add", SingletonInstructions.ADD);
    public static final SimplerInstructionProvider SUB = Instructions.registerSingleton("sub", SingletonInstructions.SUB);
    public static final SimplerInstructionProvider MUL = Instructions.registerSingleton("mul", SingletonInstructions.MUL);
    public static final SimplerInstructionProvider DIV = Instructions.registerSingleton("div", SingletonInstructions.DIV);
    public static final SimplerInstructionProvider NOT = Instructions.registerSingleton("not", SingletonInstructions.NOT);
    public static final SimplerInstructionProvider AND = Instructions.registerSingleton("and", SingletonInstructions.AND);
    public static final SimplerInstructionProvider OR = Instructions.registerSingleton("or", SingletonInstructions.OR);
    public static final SimplerInstructionProvider NAND = Instructions.registerSingleton("nand", SingletonInstructions.NAND);
    public static final SimplerInstructionProvider NOR = Instructions.registerSingleton("nor", SingletonInstructions.NOR);
    public static final SimplerInstructionProvider XOR = Instructions.registerSingleton("xor", SingletonInstructions.XOR);
    public static final SimplerInstructionProvider XNOR = Instructions.registerSingleton("xnor", SingletonInstructions.XNOR);
    public static final SimplerInstructionProvider SHR = Instructions.register(new SimplerInstructionProvider(SHRInstruction::new, SHRInstruction::parser, "SHR"));
    public static final SimplerInstructionProvider SHL = Instructions.register(new SimplerInstructionProvider(SHLInstruction::new, SHLInstruction::parser, "SHL"));
    public static final InstructionProvider JUMP = Instructions.register(new SimplerInstructionProvider((worldSupplier, nbt) -> new JumpInstruction(nbt), new JumpInstructionParser((Int2ObjectFunction<Instruction>)((Int2ObjectFunction)JumpInstruction::new)), "JMP"));
    public static final SimplerInstructionProvider BIT = Instructions.register(new SimplerInstructionProvider((w, n) -> new BITInstruction(n), new JumpInstructionParser((Int2ObjectFunction<Instruction>)((Int2ObjectFunction)BITInstruction::new)), "BIT"));
    public static final SimplerInstructionProvider BIF = Instructions.register(new SimplerInstructionProvider((w, n) -> new BIFInstruction(n), new JumpInstructionParser((Int2ObjectFunction<Instruction>)((Int2ObjectFunction)BIFInstruction::new)), "BIF"));
    public static final SimplerInstructionProvider SAY = Instructions.register(new SimplerInstructionProvider((w, n) -> new SayInstruction(n), new SayInstruction.Parser(), "SAY"));
    public static final InstructionProvider REMOVE = Instructions.register(new SimpleInstructionProvider(RemoveInstruction::new, RemoveInstruction::new, 1, "REMOVE"));
    public static final InstructionProvider ROBOT = Instructions.register(new SimpleInstructionProvider(RobotInstruction::new, RobotInstruction::new, 1, "ROBOT")).factory(PredicatedInstructionBuilder.create().arg(ArgumentPredicates.IS_ACTUATOR));
    public static final InstructionProvider EXEC = Instructions.register(new SimplerInstructionProvider(ExecInstruction::new, ExecInstruction::parser, "EXEC"));
    public static final InstructionProvider COMBINE = Instructions.register(new SimpleInstructionProvider(CombineInstruction::new, CombineInstruction::new, 2, "COMBINE").factory(PredicatedInstructionBuilder.create().arg(ArgumentPredicates.IS_ITEM_STORAGE).arg(ArgumentPredicates.IS_ITEM_MIP)));
    public static final InstructionProvider MOVE = Instructions.register(new SimpleInstructionProvider(MoveInstruction::new, MoveInstruction::new, 2, "MOVE").factory(PredicatedInstructionBuilder.create().arg(ArgumentPredicates.IS_ITEM_STORAGE).arg(ArgumentPredicates.IS_ITEM_STORAGE))).parser((view, parser, scope) -> MoveInstruction.parser(view, parser));
    public static final InstructionProvider IMPLANT = Instructions.register(new SimpleInstructionProvider(ImplantInstruction::new, ImplantInstruction::new, 2, "IMPLANT").factory(PredicatedInstructionBuilder.create().arg(ArgumentPredicates.IS_ITEM_STORAGE).arg(ArgumentPredicates.IS_ENTITY_MIP)));
    public static final InstructionProvider INJECT = Instructions.register(new SimpleInstructionProvider(InjectInstruction::new, InjectInstruction::new, 2, "INJECT").factory(PredicatedInstructionBuilder.create().arg(ArgumentPredicates.IS_FLUID_STORAGE).arg(ArgumentPredicates.IS_ITEM_ENTITY_MIP)));
    public static final SimplerInstructionProvider ROUTE = Instructions.register(new SimplerInstructionProvider(RouteItemInstruction::new, (view, parser, scope) -> RouteItemInstruction.parser(view, parser), "ROUTE"));
    public static final SimplerInstructionProvider REQUEST = Instructions.register(new SimplerInstructionProvider(RequestItemInstruction::new, (view, parser, scope) -> RequestItemInstruction.parser(view, parser), "REQUEST"));
    public static final SimplerInstructionProvider COUNT = Instructions.register(new SimplerInstructionProvider(CountInstruction::new, (view, parser, scope) -> CountInstruction.parser(view, parser), "COUNT"));
    public static final InstructionProvider WAIT_REDSTONE = Instructions.register(new SimplerInstructionProvider(WaitRedstoneInstruction::new, (view, parser, scope) -> WaitRedstoneInstruction.parser(view, parser), "RWAIT"));
    public static final InstructionProvider EMIT_REDSTONE = Instructions.register(new SimplerInstructionProvider(EmitRedstoneInstruction::new, (view, parser, scope) -> EmitRedstoneInstruction.parser(view, parser), "REMIT"));
    public static final InstructionProvider READ_REDSTONE = Instructions.register(new SimplerInstructionProvider(ReadRedstoneInstruction::new, (view, parser, scope) -> ReadRedstoneInstruction.parser(view, parser), "RREAD"));
    public static final InstructionProvider NEEPBUS_WRITE = Instructions.register(new SimplerInstructionProvider(NeepBusWriteInstruction::new, NeepBusWriteInstruction::parser, "NBWRITE"));
    public static final InstructionProvider NEEPBUS_READ = Instructions.register(new SimplerInstructionProvider(NeepBusReadInstruction::new, NeepBusReadInstruction::parser, "NBREAD"));

    private static <T extends InstructionProvider> T register(T provider) {
        REGISTRY.put(provider.getParseName(), provider);
        return provider;
    }

    private static <T extends SimplerInstructionProvider> SimplerInstructionProvider registerSingleton(String path, Instruction instruction) {
        return Instructions.register(new SimplerInstructionProvider((w, n) -> instruction, Instructions.parseNoArguments(instruction), path.toLowerCase(Locale.ROOT)));
    }

    private static <T extends SimplerInstructionProvider> SimplerInstructionProvider registerSingleton(String path, final Supplier<InstructionProvider> supplier, final Consumer<PLC> operation) {
        SimpleInstruction instruction = new SimpleInstruction(){

            @Override
            public void start(PLC plc) throws NeepASM.RuntimeException {
                operation.accept(plc);
            }

            @Override
            @NotNull
            public InstructionProvider getOpcode() {
                return (InstructionProvider)supplier.get();
            }
        };
        return Instructions.registerSingleton(path, instruction);
    }

    static InstructionParser parseNoArguments(Instruction instruction) {
        return (view, parser, scope) -> {
            view.fastForward();
            parser.assureLineEnd(view);
            return (source, program) -> instruction;
        };
    }

    public static ResourceAmount<ItemVariant> takeItem(Argument target, Supplier<class_1937> world, int count, Pattern pattern) {
        Storage storage = (Storage)ItemStorage.SIDED.find(world.get(), target.pos(), (Object)target.face());
        if (storage != null) {
            try (Transaction transaction = Transaction.openOuter();){
                ResourceAmount found = StorageUtil.findExtractableContent((Storage)storage, (TransactionContext)transaction);
                if (found != null && Instructions.match(pattern, ((ItemVariant)found.resource()).getItem())) {
                    long extracted = storage.extract((Object)((ItemVariant)found.resource()), Math.min(found.amount(), (long)count), (TransactionContext)transaction);
                    if (extracted > 0L) {
                        ResourceAmount res = new ResourceAmount((Object)((ItemVariant)found.resource()), extracted);
                        transaction.commit();
                        ResourceAmount resourceAmount = res;
                        return resourceAmount;
                    }
                    transaction.abort();
                }
            }
        }
        return null;
    }

    public static ResourceAmount<FluidVariant> takeFluid(Argument target, Supplier<class_1937> world, long amount) {
        Storage storage = (Storage)FluidStorage.SIDED.find(world.get(), target.pos(), (Object)target.face());
        if (storage != null) {
            try (Transaction transaction = Transaction.openOuter();){
                long extracted;
                ResourceAmount found = StorageUtil.findExtractableContent((Storage)storage, (TransactionContext)transaction);
                if (found != null && (extracted = storage.extract((Object)((FluidVariant)found.resource()), amount, (TransactionContext)transaction)) == amount) {
                    transaction.commit();
                    ResourceAmount resourceAmount = new ResourceAmount((Object)((FluidVariant)found.resource()), amount);
                    return resourceAmount;
                }
            }
        }
        return null;
    }

    public static long giveFluid(Argument target, Supplier<class_1937> world, ResourceAmount<FluidVariant> resourceAmount) {
        Storage storage = (Storage)FluidStorage.SIDED.find(world.get(), target.pos(), (Object)target.face());
        if (storage != null) {
            try (Transaction transaction = Transaction.openOuter();){
                long inserted = storage.insert((Object)((FluidVariant)resourceAmount.resource()), resourceAmount.amount(), (TransactionContext)transaction);
                transaction.commit();
                long l = inserted;
                return l;
            }
        }
        return 0L;
    }

    public static class_2487 labelToNbt(Label label) {
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10582("name", label.name());
        nbtCompound.method_10569("index", label.index());
        return nbtCompound;
    }

    public static Label labelFromNbt(class_2487 nbt) {
        return new Label(nbt.method_10558("name"), nbt.method_10550("index"));
    }

    public static boolean match(Pattern pattern, class_1792 item) {
        return pattern.asMatchPredicate().test(item.method_40131().method_40237().method_29177().toString());
    }

    public static <T> String parseRegistryGlob(NeepAsmTokenView view, class_2378<T> registry, String type) throws NeepASM.ParseException {
        Object item;
        String notGlob = view.nextString();
        if (notGlob == null) {
            throw new NeepASM.ParseException("expected %s ID string (minecraft:stone)".formatted(type));
        }
        if (NeepAsmParser.isSimplePattern(notGlob) && (item = registry.method_17966(class_2960.method_12829((String)notGlob)).orElse(null)) == null) {
            throw new NeepASM.ParseException("%s '%s' not known".formatted(type, notGlob));
        }
        return NeepAsmParser.convertToRegex(notGlob);
    }
}

