/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.vm.DataStack;
import com.neep.neepmeat.neepasm.vm.VM;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.instruction.Instruction;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import org.jetbrains.annotations.NotNull;

public abstract class ComparisonInstruction
implements Instruction {
    @Override
    @NotNull
    public abstract InstructionProvider getOpcode();

    public static class GreaterThanEqual
    extends ComparisonInstruction {
        @Override
        public void start(VM plc) throws NeepASM.RuntimeException {
            DataStack stack = plc.dataStack();
            if (stack.popInt() <= stack.popInt()) {
                stack.push(-1);
            } else {
                stack.push(0);
            }
            plc.advanceCounter();
        }

        @Override
        @NotNull
        public InstructionProvider getOpcode() {
            return Instructions.GTEQ;
        }
    }

    public static class GreaterThan
    extends ComparisonInstruction {
        @Override
        public void start(VM plc) throws NeepASM.RuntimeException {
            DataStack stack = plc.dataStack();
            if (stack.popInt() < stack.popInt()) {
                stack.push(-1);
            } else {
                stack.push(0);
            }
            plc.advanceCounter();
        }

        @Override
        @NotNull
        public InstructionProvider getOpcode() {
            return Instructions.GT;
        }
    }

    public static class LessThanEqual
    extends ComparisonInstruction {
        @Override
        public void start(VM plc) throws NeepASM.RuntimeException {
            DataStack stack = plc.dataStack();
            if (stack.popInt() >= stack.popInt()) {
                stack.push(-1);
            } else {
                stack.push(0);
            }
            plc.advanceCounter();
        }

        @Override
        @NotNull
        public InstructionProvider getOpcode() {
            return Instructions.LTEQ;
        }
    }

    public static class LessThan
    extends ComparisonInstruction {
        @Override
        public void start(VM plc) throws NeepASM.RuntimeException {
            DataStack stack = plc.dataStack();
            if (stack.popInt() > stack.popInt()) {
                stack.push(-1);
            } else {
                stack.push(0);
            }
            plc.advanceCounter();
        }

        @Override
        @NotNull
        public InstructionProvider getOpcode() {
            return Instructions.LT;
        }
    }

    public static class Equals
    extends ComparisonInstruction {
        @Override
        public void start(VM plc) throws NeepASM.RuntimeException {
            DataStack stack = plc.dataStack();
            if (stack.popInt() == stack.popInt()) {
                stack.push(-1);
            } else {
                stack.push(0);
            }
            plc.advanceCounter();
        }

        @Override
        @NotNull
        public InstructionProvider getOpcode() {
            return Instructions.EQ;
        }
    }
}

