/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.plc.interrupt.InterruptReceiver;
import com.neep.neepmeat.api.plc.robot.RobotAction;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import org.jetbrains.annotations.NotNull;

public class WaitForInterruptInstruction
implements PlcInstruction {
    public static final WaitForInterruptInstruction INSTANCE = new WaitForInterruptInstruction();

    private WaitForInterruptInstruction() {
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        if (plc instanceof InterruptReceiver) {
            InterruptReceiver receiver = (InterruptReceiver)plc;
            receiver.getInterrupts().setEnabled(true);
        }
        plc.addRobotAction(new WaitAction(), this::finish);
    }

    private void finish(PLC plc) {
        plc.advanceCounter();
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.IWAIT;
    }

    public static void disableInterrupts(PLC plc) {
        if (plc instanceof InterruptReceiver) {
            InterruptReceiver receiver = (InterruptReceiver)plc;
            receiver.setEnabled(false);
        }
        plc.advanceCounter();
    }

    public static void enableInterrupts(PLC plc) {
        if (plc instanceof InterruptReceiver) {
            InterruptReceiver receiver = (InterruptReceiver)plc;
            receiver.setEnabled(true);
        }
        plc.advanceCounter();
    }

    public static void clearInterrupts(PLC plc) {
        if (plc instanceof InterruptReceiver) {
            InterruptReceiver receiver = (InterruptReceiver)plc;
            receiver.getInterrupts().clear();
        }
        plc.advanceCounter();
    }

    private static class WaitAction
    implements RobotAction {
        private WaitAction() {
        }

        @Override
        public boolean finished(PLC plc) {
            if (plc instanceof InterruptReceiver) {
                InterruptReceiver receiver = (InterruptReceiver)plc;
                return receiver.getInterrupts().hasQueued();
            }
            return false;
        }

        @Override
        public void start(PLC plc) {
        }

        @Override
        public void tick(PLC plc) {
        }

        @Override
        public void end(PLC plc) {
        }
    }
}

