/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.recipe.MeatRecipeSerialiser;
import com.neep.meatlib.recipe.MeatRecipeType;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.entity.EntityRecipeInput;
import com.neep.meatlib.util.MeatLibCodecs;
import com.neep.neepmeat.api.plc.recipe.ManufactureStep;
import com.neep.neepmeat.api.plc.recipe.Workpiece;
import com.neep.neepmeat.implant.entity.EntityImplantInstaller;
import com.neep.neepmeat.init.NMComponents;
import com.neep.neepmeat.plc.component.MutateInPlace;
import com.neep.neepmeat.plc.recipe.EntityMutateRecipe;
import com.neep.neepmeat.plc.recipe.ItemManufactureRecipe;
import com.neep.neepmeat.plc.recipe.PLCRecipes;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class EntityImplantRecipe
extends EntityMutateRecipe {
    private final EntityImplantInstaller implant;

    public EntityImplantRecipe(class_2960 id, EntityRecipeInput base, List<ManufactureStep<?>> steps, EntityImplantInstaller implant) {
        super(id, base, steps);
        this.implant = implant;
    }

    @Override
    public boolean matches(MutateInPlace<class_1297> context) {
        class_1297 entity = context.get();
        if (!this.base.test(entity)) {
            return false;
        }
        Workpiece workpiece = (Workpiece)NMComponents.WORKPIECE.getNullable((Object)entity);
        if (workpiece != null) {
            List<ManufactureStep<?>> workSteps = workpiece.getSteps();
            if (workSteps.size() < this.steps.size()) {
                return false;
            }
            int difference = workSteps.size() - this.steps.size();
            for (int i = this.steps.size() - 1; i >= 0; --i) {
                ManufactureStep recipeStep;
                ManufactureStep<?> workStep = workSteps.get(i + difference);
                if (ManufactureStep.matches(workStep, recipeStep = (ManufactureStep)this.steps.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public EntityRecipeInput getBase() {
        return this.base;
    }

    @Override
    public List<ManufactureStep<?>> getSteps() {
        return this.steps;
    }

    @Override
    public boolean takeInputs(MutateInPlace<class_1297> context, TransactionContext transaction) {
        return false;
    }

    @Override
    public boolean ejectOutputs(MutateInPlace<class_1297> context, TransactionContext transaction) {
        this.implant.install(context.get());
        return false;
    }

    public MeatRecipeType<?> getType() {
        return PLCRecipes.ENTITY_MANUFACTURE;
    }

    @Override
    public MeatRecipeSerialiser<?> getSerializer() {
        return PLCRecipes.ENTITY_MANUFACTURE_SERIALISER;
    }

    public static class Serialiser
    implements MeatRecipeSerialiser<EntityImplantRecipe> {
        private final Codec<MeatRecipeSerialiser.RecipeFunction<EntityImplantRecipe>> codec = RecordCodecBuilder.create(instance -> instance.group((App)RecipeInputs.ENTITY.codec().fieldOf("base").forGetter(MeatLibCodecs::notImplemented), (App)ManufactureStep.LIST_CODEC.fieldOf("steps").forGetter(MeatLibCodecs::notImplemented), (App)EntityImplantInstaller.CODEC.fieldOf("implant_installer").forGetter(MeatLibCodecs::notImplemented)).apply((Applicative)instance, (b, s, r) -> id -> new EntityImplantRecipe(id, (EntityRecipeInput)b, (List<ManufactureStep<?>>)s, (EntityImplantInstaller)r)));

        @Override
        public Codec<MeatRecipeSerialiser.RecipeFunction<EntityImplantRecipe>> codec() {
            return this.codec;
        }

        @Override
        public EntityImplantRecipe read(class_2960 id, class_2540 buf) {
            EntityRecipeInput base = RecipeInputs.ENTITY.fromBuffer(buf);
            List<ManufactureStep<?>> steps = ItemManufactureRecipe.Serialiser.readSteps(buf);
            EntityImplantInstaller implant = (EntityImplantInstaller)buf.method_42064(EntityImplantInstaller.REGISTRY);
            return new EntityImplantRecipe(id, base, steps, implant);
        }

        @Override
        public void write(class_2540 buf, EntityImplantRecipe recipe) {
            recipe.base.write(buf);
            ItemManufactureRecipe.Serialiser.writeSteps(recipe.getSteps(), buf);
            buf.method_42065(EntityImplantInstaller.REGISTRY, (Object)recipe.implant);
        }
    }
}

