/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.recipe.MeatRecipeSerialiser;
import com.neep.meatlib.recipe.MeatRecipeType;
import com.neep.meatlib.recipe.MeatlibRecipe;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RecipeOutputImpl;
import com.neep.meatlib.recipe.ingredient.RecipeOutputs;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import com.neep.meatlib.util.MeatLibCodecs;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.grinder.CrusherRecipeContext;
import java.util.Iterator;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class CrushingRecipe
implements MeatlibRecipe<CrusherRecipeContext> {
    protected class_2960 id;
    protected RegistryRecipeInput<class_1792> itemInput;
    protected RecipeOutput<class_1792> itemOutput;
    protected RecipeOutput<class_1792> extraOutput;
    protected float experience;
    protected int processTime;

    public CrushingRecipe(class_2960 id, RegistryRecipeInput<class_1792> itemInput, RecipeOutput<class_1792> itemOutput, RecipeOutput<class_1792> extraOutput, float experience, int processTime) {
        this.itemInput = itemInput;
        this.itemOutput = itemOutput;
        this.extraOutput = extraOutput;
        this.experience = experience;
        this.processTime = processTime;
        this.id = id;
    }

    public boolean destroy() {
        return false;
    }

    @Override
    public boolean matches(CrusherRecipeContext inventory) {
        return this.itemInput.testStorage(inventory.getInputStorage());
    }

    public RegistryRecipeInput<class_1792> getItemInput() {
        return this.itemInput;
    }

    public RecipeOutput<class_1792> getItemOutput() {
        return this.itemOutput;
    }

    public RecipeOutput<class_1792> getAuxOutput() {
        return this.extraOutput;
    }

    @Override
    public class_2960 method_8114() {
        return this.id;
    }

    @Override
    public MeatRecipeSerialiser<?> getSerializer() {
        return NMrecipeTypes.GRINDING_SERIALIZER;
    }

    public MeatRecipeType<?> getType() {
        return NMrecipeTypes.GRINDING;
    }

    public int getTime() {
        return this.processTime;
    }

    @Override
    public boolean takeInputs(CrusherRecipeContext storage, TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            Optional<class_1792> item = this.itemInput.getFirstMatching(storage.getInputStorage(), (TransactionContext)inner);
            if (item.isEmpty()) {
                inner.abort();
                boolean bl = false;
                return bl;
            }
            long extracted = storage.getInputStorage().extract((Object)ItemVariant.of((class_1935)((class_1935)item.get())), this.itemInput.amount(), (TransactionContext)inner);
            if (extracted == this.itemInput.amount()) {
                inner.commit();
                boolean bl = true;
                return bl;
            }
            inner.abort();
        }
        return false;
    }

    @Override
    public boolean ejectOutputs(CrusherRecipeContext context, TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            boolean bl3;
            boolean bl1 = this.itemOutput.insertInto(context.getOutputStorage(), ItemVariant::of, (TransactionContext)inner);
            boolean bl2 = this.extraOutput == null || this.extraOutput.insertInto(context.getExtraStorage(), ItemVariant::of, context.getChanceMod(), (TransactionContext)inner);
            boolean bl = bl3 = context.getXpStorage().insert(this.experience, transaction) == this.experience;
            if (bl1 && bl2 && bl3) {
                inner.commit();
                boolean bl4 = true;
                return bl4;
            }
            inner.abort();
        }
        return false;
    }

    public static class DestroyRecipe
    extends CrushingRecipe {
        public DestroyRecipe(class_2960 id) {
            super(id, RecipeInputs.empty(), RecipeOutput.empty(), RecipeOutput.empty(), 0.0f, 40);
        }

        @Override
        public boolean destroy() {
            return true;
        }

        @Override
        public boolean matches(CrusherRecipeContext inventory) {
            return false;
        }

        @Override
        public boolean takeInputs(CrusherRecipeContext storage, TransactionContext transaction) {
            Iterator it = storage.getInputStorage().nonEmptyIterator();
            if (it.hasNext()) {
                StorageView view = (StorageView)it.next();
                view.extract((Object)((ItemVariant)view.getResource()), 1L, transaction);
                return true;
            }
            return false;
        }

        @Override
        public boolean ejectOutputs(CrusherRecipeContext context, TransactionContext transaction) {
            return true;
        }
    }

    public static class Serializer<T extends CrushingRecipe>
    implements MeatRecipeSerialiser<T> {
        private final RecipeFactory<T> factory;
        private final DestroyRecipeFactory<T> destroyFactory;
        private final int processTIme;
        private final Codec<MeatRecipeSerialiser.RecipeFunction<T>> codec;

        public Serializer(RecipeFactory<T> recipeFactory, DestroyRecipeFactory<T> destroyFactory, int processTime) {
            this.factory = recipeFactory;
            this.destroyFactory = destroyFactory;
            this.processTIme = processTime;
            Codec c1 = Codec.BOOL.xmap(b -> destroyFactory::create, MeatLibCodecs::notImplemented).fieldOf("destroy").codec();
            Codec c2 = RecordCodecBuilder.create(instance -> instance.group((App)RecipeInputs.ITEM.codec().fieldOf("input").forGetter(MeatLibCodecs::notImplemented), (App)RecipeOutputs.ITEM.fieldOf("output").forGetter(MeatLibCodecs::notImplemented), (App)RecipeOutputs.ITEM.optionalFieldOf("extra").forGetter(MeatLibCodecs::notImplemented), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(MeatLibCodecs::notImplemented), (App)Codec.INT.optionalFieldOf("processtime", (Object)this.processTIme).forGetter(MeatLibCodecs::notImplemented)).apply((Applicative)instance, (i, o, e, ex, t) -> id -> this.factory.create(id, (RegistryRecipeInput<class_1792>)i, (RecipeOutput<class_1792>)o, e.orElse(null), ex.floatValue(), (int)t)));
            this.codec = Codec.either((Codec)c1, (Codec)c2).xmap(MeatLibCodecs::collapseEither, Either::left);
        }

        @Override
        public Codec<MeatRecipeSerialiser.RecipeFunction<T>> codec() {
            return this.codec;
        }

        @Override
        public T read(class_2960 id, class_2540 buf) {
            if (buf.readBoolean()) {
                return this.destroyFactory.create(id);
            }
            RegistryRecipeInput<class_1792> itemInput = RegistryRecipeInput.fromBuffer(buf);
            RecipeOutputImpl<class_1792> itemOutput = RecipeOutputImpl.read(class_7923.field_41178, buf);
            RecipeOutputImpl<class_1792> extraOutput = null;
            if (buf.readBoolean()) {
                extraOutput = RecipeOutputImpl.read(class_7923.field_41178, buf);
            }
            float experience = buf.readFloat();
            int time = buf.method_10816();
            return this.factory.create(id, itemInput, itemOutput, extraOutput, experience, time);
        }

        @Override
        public void write(class_2540 buf, CrushingRecipe recipe) {
            if (recipe.destroy()) {
                buf.writeBoolean(true);
                return;
            }
            buf.writeBoolean(false);
            recipe.itemInput.write(buf);
            recipe.itemOutput.write(buf);
            if (recipe.extraOutput != null) {
                buf.writeBoolean(true);
                recipe.extraOutput.write(buf);
            } else {
                buf.writeBoolean(false);
            }
            buf.writeFloat(recipe.experience);
            buf.method_10804(recipe.processTime);
        }

        @FunctionalInterface
        public static interface RecipeFactory<T extends CrushingRecipe> {
            public T create(class_2960 var1, RegistryRecipeInput<class_1792> var2, RecipeOutput<class_1792> var3, @Nullable RecipeOutput<class_1792> var4, float var5, int var6);
        }

        public static interface DestroyRecipeFactory<T extends CrushingRecipe> {
            public T create(class_2960 var1);
        }
    }
}

