/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.recipe.MeatRecipeSerialiser;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import com.neep.meatlib.util.MeatLibCodecs;
import com.neep.neepmeat.api.processing.OreFatRegistry;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.casting_basin.CastingBasinStorage;
import com.neep.neepmeat.recipe.AbstractPressingRecipe;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3956;

public class FatPressingRecipe
extends AbstractPressingRecipe<CastingBasinStorage> {
    protected class_2960 id;
    protected RegistryRecipeInput<class_3611> fluidInput;

    public FatPressingRecipe(class_2960 id, RegistryRecipeInput<class_3611> fluidInput) {
        this.fluidInput = fluidInput;
        this.id = id;
    }

    @Override
    public boolean matches(CastingBasinStorage inventory) {
        WritableSingleFluidStorage storage = inventory.fluid(null);
        return OreFatRegistry.getFromVariant((FluidVariant)storage.getResource()) != null && this.fluidInput.amount() == storage.getAmount();
    }

    public RegistryRecipeInput<class_3611> getFluidInput() {
        return this.fluidInput;
    }

    @Override
    public class_2960 method_8114() {
        return this.id;
    }

    @Override
    public MeatRecipeSerialiser<?> getSerializer() {
        return NMrecipeTypes.FAT_PRESSING_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return NMrecipeTypes.FAT_PRESSING;
    }

    @Override
    public boolean takeInputs(CastingBasinStorage storage, TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            WritableSingleFluidStorage fluidStorage = storage.fluid(null);
            FluidVariant fluidVariant = (FluidVariant)fluidStorage.getResource();
            OreFatRegistry.Entry entry = OreFatRegistry.getFromVariant(fluidVariant);
            if (entry == null) {
                throw new IllegalStateException("Storage contents do not conform to recipe");
            }
            storage.unlock();
            long ex2 = fluidStorage.extract((TransferVariant)((FluidVariant)fluidStorage.getResource()), this.fluidInput.amount(), (TransactionContext)inner);
            storage.lock();
            if (ex2 != this.fluidInput.amount()) {
                inner.abort();
                boolean bl = false;
                return bl;
            }
            long insertAmount = 1L;
            long transferred = storage.item(null).insert((TransferVariant)entry.result(), insertAmount, (TransactionContext)inner);
            if (transferred == insertAmount) {
                inner.commit();
                boolean bl = true;
                return bl;
            }
            inner.abort();
        }
        return false;
    }

    public static class Serializer
    implements MeatRecipeSerialiser<FatPressingRecipe> {
        private final Codec<MeatRecipeSerialiser.RecipeFunction<FatPressingRecipe>> codec = RecordCodecBuilder.create(instance -> instance.group((App)RecipeInputs.FLUID.codec().fieldOf("fluid_input").forGetter(MeatLibCodecs::notImplemented)).apply((Applicative)instance, i -> id -> new FatPressingRecipe(id, (RegistryRecipeInput<class_3611>)i)));

        @Override
        public Codec<MeatRecipeSerialiser.RecipeFunction<FatPressingRecipe>> codec() {
            return this.codec;
        }

        @Override
        public FatPressingRecipe read(class_2960 id, class_2540 buf) {
            RegistryRecipeInput<class_3611> fluidInput = RegistryRecipeInput.fromBuffer(buf);
            return new FatPressingRecipe(id, fluidInput);
        }

        @Override
        public void write(class_2540 buf, FatPressingRecipe recipe) {
            recipe.fluidInput.write(buf);
        }

        @FunctionalInterface
        public static interface RecipeFactory<T extends FatPressingRecipe> {
            public T create(class_2960 var1, RegistryRecipeInput<class_3611> var2);
        }
    }
}

