/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.recipe;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.recipe.MeatRecipeSerialiser;
import com.neep.meatlib.recipe.MeatRecipeType;
import com.neep.meatlib.recipe.MeatlibRecipe;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RecipeOutputImpl;
import com.neep.meatlib.recipe.ingredient.RecipeOutputs;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import com.neep.meatlib.util.MeatLibCodecs;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.multitank.MultiTankBlockEntity;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;

public class FluidHeatingRecipe
implements MeatlibRecipe<MultiTankBlockEntity> {
    protected class_2960 id;
    protected RegistryRecipeInput<class_3611> fluidInput;
    protected RecipeOutput<class_3611> fluidOutput;
    protected int processTime;

    public FluidHeatingRecipe(class_2960 id, RegistryRecipeInput<class_3611> fluidInput, RecipeOutput<class_3611> fluidOutput, int processTime) {
        this.fluidInput = fluidInput;
        this.fluidOutput = fluidOutput;
        this.processTime = processTime;
        this.id = id;
    }

    @Override
    public boolean matches(MultiTankBlockEntity inventory) {
        for (Map.Entry entry : inventory.getStorage().getSlots()) {
            if (!this.fluidInput.test((TransferVariant)entry.getKey(), (Long)entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public RegistryRecipeInput<class_3611> getFluidInput() {
        return this.fluidInput;
    }

    public RecipeOutput<class_3611> getFluidOutput() {
        return this.fluidOutput;
    }

    @Override
    public class_2960 method_8114() {
        return this.id;
    }

    @Override
    public MeatRecipeSerialiser<?> getSerializer() {
        return NMrecipeTypes.HEATING_SERIALISER;
    }

    public MeatRecipeType<?> getType() {
        return NMrecipeTypes.HEATING;
    }

    public int getTime() {
        return this.processTime;
    }

    @Override
    public boolean takeInputs(MultiTankBlockEntity storage, TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            Optional<class_3611> fluid = this.fluidInput.getFirstMatching(storage.getStorage(), transaction);
            if (!fluid.isPresent()) {
                boolean bl = false;
                return bl;
            }
            long extracted = storage.getStorage().extract(FluidVariant.of((class_3611)fluid.get()), this.fluidInput.amount(), transaction);
            if (extracted == this.fluidInput.amount()) {
                inner.commit();
                boolean bl = true;
                return bl;
            }
            inner.abort();
        }
        return false;
    }

    @Override
    public boolean ejectOutputs(MultiTankBlockEntity context, TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            boolean bl1 = this.fluidOutput.insertInto(context.getStorage(), FluidVariant::of, (TransactionContext)inner);
            if (bl1) {
                inner.commit();
                boolean bl = true;
                return bl;
            }
            inner.abort();
        }
        return false;
    }

    public static class Serializer
    implements MeatRecipeSerialiser<FluidHeatingRecipe> {
        private final Codec<MeatRecipeSerialiser.RecipeFunction<FluidHeatingRecipe>> codec = RecordCodecBuilder.create(instance -> instance.group(MeatLibCodecs.decodeOnly(RecipeInputs.FLUID.codec().fieldOf("input")), MeatLibCodecs.decodeOnly(RecipeOutputs.FLUID.fieldOf("output")), MeatLibCodecs.decodeOnly(Codec.INT.optionalFieldOf("processtime", (Object)processTime))).apply((Applicative)instance, (i, o, t) -> id -> new FluidHeatingRecipe(id, (RegistryRecipeInput<class_3611>)i, (RecipeOutput<class_3611>)o, (int)t)));

        public Serializer(int processTime) {
        }

        @Override
        public Codec<MeatRecipeSerialiser.RecipeFunction<FluidHeatingRecipe>> codec() {
            return this.codec;
        }

        @Override
        public FluidHeatingRecipe read(class_2960 id, class_2540 buf) {
            RegistryRecipeInput<class_3611> fluidInput = RegistryRecipeInput.fromBuffer(buf);
            RecipeOutputImpl<class_3611> fluidOutput = RecipeOutputImpl.read(class_7923.field_41173, buf);
            int time = buf.method_10816();
            return new FluidHeatingRecipe(id, fluidInput, fluidOutput, time);
        }

        @Override
        public void write(class_2540 buf, FluidHeatingRecipe recipe) {
            recipe.fluidInput.write(buf);
            recipe.fluidOutput.write(buf);
            buf.method_10804(recipe.processTime);
        }
    }
}

