/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.thord.parser;

import com.neep.neepmeat.api.plc.program.MutableProgram;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.InstructionAcceptor;
import com.neep.neepmeat.neepasm.compiler.LabelLookup;
import com.neep.neepmeat.neepasm.compiler.ParsedFunction;
import com.neep.neepmeat.neepasm.compiler.parser.ParsedInstruction;
import com.neep.neepmeat.neepasm.program.Label;
import com.neep.neepmeat.neepasm.vm.VM;
import com.neep.neepmeat.thord.parser.ExecutionProgram;
import com.neep.neepmeat.thord.word.Word;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ParsedImmediateWord
implements InstructionAcceptor,
LabelLookup {
    private final List<ObjectIntPair<Word>> words = new ObjectArrayList();
    private final List<Label> labels = new ObjectArrayList();
    private final MutableProgram program;
    private final VM machine;

    public ParsedImmediateWord(VM machine) {
        this.machine = machine;
        this.program = new ExecutionProgram();
    }

    public void word(Word word, int line) {
        this.words.add((ObjectIntPair<Word>)ObjectIntPair.of((Object)word, (int)line));
    }

    @Override
    public void instruction(ParsedInstruction preInstruction, int line) {
        this.word((acceptor, stack, line1) -> preInstruction.build(this, this.program).start(this.machine), line);
    }

    @Override
    public void instruction(int index, ParsedInstruction preInstruction, int line) {
    }

    @Override
    public void function(ParsedFunction function) throws NeepASM.CompilationException {
        throw new NeepASM.CompilationException("cannot define word here");
    }

    @Override
    public void label(Label label) {
        this.labels.add(new Label(label.name(), this.words.size()));
    }

    @Override
    public int size() {
        return this.words.size();
    }

    public List<ObjectIntPair<Word>> getWords() {
        return this.words;
    }

    @Override
    @Nullable
    public Label findLabel(String label) {
        return this.labels.stream().filter(l -> l.name().equals(label)).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public Label findLabel(String label, int origin, Label.Seek seek) {
        return switch (seek) {
            default -> throw new IncompatibleClassChangeError();
            case Label.Seek.FORWARDS -> LabelLookup.findForwards(this.labels, label, origin);
            case Label.Seek.BACKWARDS -> LabelLookup.findBackwards(this.labels, label, origin);
            case Label.Seek.ABSOLUTE -> this.findLabel(label);
        };
    }
}

