/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.thord.parser;

import com.google.common.collect.Lists;
import com.neep.meatlib.util.StringTokenView;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.thord.token.ThordTokenView;
import java.util.ArrayList;
import java.util.List;

public class ThordMacro {
    private final String name;
    private final String string;
    private final List<String> parameters;
    private final int startLine;

    public ThordMacro(String name, List<String> parameters, String string, int startLine) {
        this.name = name;
        this.string = string;
        this.parameters = parameters;
        this.startLine = startLine;
    }

    public String expand(ThordTokenView view) throws NeepASM.ParseException {
        ArrayList arguments = Lists.newArrayList();
        for (int i = 0; i < this.parameters.size(); ++i) {
            view.fastForward();
            String arg = ThordMacro.parseArgumentString(view);
            if (arg.isEmpty()) {
                throw new NeepASM.ParseException("not enough comma-separated macro arguments.");
            }
            if (!view.lineEnded()) {
                view.next();
            }
            arguments.add(arg);
        }
        view.fastForward();
        String processed = this.string;
        for (int i = 0; i < this.parameters.size(); ++i) {
            processed = processed.replace("%" + this.parameters.get(i), (CharSequence)arguments.get(i));
        }
        return processed;
    }

    public static String parseArgumentString(StringTokenView view) {
        view.fastForward();
        StringBuilder builder = new StringBuilder();
        while (!(view.peek() == ',' || NeepAsmParser.isComment(view) || view.eof() || view.lineEnded() || view.peek() == ';')) {
            builder.append(view.next());
        }
        if (view.peek() == ';') {
            view.next();
        }
        return builder.toString().strip();
    }

    public String name() {
        return this.name;
    }

    public int getStartLine() {
        return this.startLine;
    }
}

