/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.api.pipe;

import com.google.common.collect.Maps;
import com.neep.meatlib.block.MeatlibBlock;
import com.neep.meatlib.item.ItemSettings;
import com.neep.meatlib.registry.RegistrationContext;
import com.neep.neepmeat.transport.fluid_network.ConnectionType;
import com.neep.neepmeat.transport.fluid_network.SimplePipeProperties;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_4970;

public abstract class SimplePipeBlock
extends class_2248
implements MeatlibBlock {
    public final class_1747 blockItem;
    public static final class_2754<ConnectionType> NORTH_CONNECTION = SimplePipeProperties.NORTH_CONNECTION;
    public static final class_2754<ConnectionType> EAST_CONNECTION = SimplePipeProperties.EAST_CONNECTION;
    public static final class_2754<ConnectionType> SOUTH_CONNECTION = SimplePipeProperties.SOUTH_CONNECTION;
    public static final class_2754<ConnectionType> WEST_CONNECTION = SimplePipeProperties.WEST_CONNECTION;
    public static final class_2754<ConnectionType> UP_CONNECTION = SimplePipeProperties.UP_CONNECTION;
    public static final class_2754<ConnectionType> DOWN_CONNECTION = SimplePipeProperties.DOWN_CONNECTION;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final Map<class_2350, class_2754<ConnectionType>> DIR_TO_CONNECTION = (Map)class_156.method_654(new EnumMap(class_2350.class), map -> {
        map.put(class_2350.field_11043, NORTH_CONNECTION);
        map.put(class_2350.field_11034, EAST_CONNECTION);
        map.put(class_2350.field_11035, SOUTH_CONNECTION);
        map.put(class_2350.field_11039, WEST_CONNECTION);
        map.put(class_2350.field_11033, DOWN_CONNECTION);
        map.put(class_2350.field_11036, UP_CONNECTION);
    });
    public static final Map<class_2350, class_265> DIR_SHAPES = (Map)class_156.method_654(new EnumMap(class_2350.class), map -> {
        map.put(class_2350.field_11043, class_2248.method_9541((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)5.0));
        map.put(class_2350.field_11034, class_2248.method_9541((double)11.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
        map.put(class_2350.field_11035, class_2248.method_9541((double)4.0, (double)4.0, (double)11.0, (double)12.0, (double)12.0, (double)16.0));
        map.put(class_2350.field_11039, class_2248.method_9541((double)0.0, (double)4.0, (double)4.0, (double)5.0, (double)12.0, (double)12.0));
        map.put(class_2350.field_11036, class_2248.method_9541((double)4.0, (double)11.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
        map.put(class_2350.field_11033, class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0));
    });
    private final Map<class_2680, class_265> shapes = Maps.newHashMap();

    public SimplePipeBlock(RegistrationContext ctx, ItemSettings itemSettings, class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(NORTH_CONNECTION, (Comparable)((Object)ConnectionType.NONE))).method_11657(EAST_CONNECTION, (Comparable)((Object)ConnectionType.NONE))).method_11657(SOUTH_CONNECTION, (Comparable)((Object)ConnectionType.NONE))).method_11657(WEST_CONNECTION, (Comparable)((Object)ConnectionType.NONE))).method_11657(UP_CONNECTION, (Comparable)((Object)ConnectionType.NONE))).method_11657(DOWN_CONNECTION, (Comparable)((Object)ConnectionType.NONE))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.blockItem = itemSettings.getFactory().create(this, ctx, itemSettings);
        for (class_2680 state : this.method_9595().method_11662()) {
            this.shapes.put(state, this.getShapeForState(state));
        }
    }

    protected class_265 getCentreShape() {
        return class_2248.method_9541((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    }

    public class_265 getShapeForState(class_2680 state) {
        class_265 shape = this.getCentreShape();
        for (class_2350 direction : class_2350.values()) {
            if (state.method_11654((class_2769)DIR_TO_CONNECTION.get(direction)) != ConnectionType.SIDE) continue;
            shape = class_259.method_1084((class_265)shape, (class_265)DIR_SHAPES.get(direction));
        }
        return shape;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        boolean connection = this.canConnectTo(neighborState, direction.method_10153(), (class_1937)world, neighborPos);
        if (connection) {
            return (class_2680)state.method_11657((class_2769)DIR_TO_CONNECTION.get(direction), (Comparable)((Object)ConnectionType.SIDE));
        }
        return (class_2680)state.method_11657((class_2769)DIR_TO_CONNECTION.get(direction), (Comparable)((Object)ConnectionType.NONE));
    }

    protected class_2680 getConnectedState(class_1922 world, class_2680 state, class_2338 pos) {
        for (class_2350 direction : class_2350.values()) {
            ConnectionType property = (ConnectionType)((Object)state.method_11654((class_2769)DIR_TO_CONNECTION.get(direction)));
            if (property == ConnectionType.SIDE) continue;
            class_2338 adjPos = pos.method_10093(direction);
            class_2680 adjState = world.method_8320(adjPos);
            boolean connection = this.canConnectTo(adjState, direction.method_10153(), (class_1937)world, adjPos);
            state = (class_2680)state.method_11657((class_2769)DIR_TO_CONNECTION.get(direction), (Comparable)((Object)(connection ? ConnectionType.SIDE : ConnectionType.NONE)));
        }
        return (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(world.method_8316(pos).method_15772() == class_3612.field_15910));
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        return this.getConnectedState((class_1922)world, this.method_9564(), pos);
    }

    public abstract boolean canConnectTo(class_2680 var1, class_2350 var2, class_1937 var3, class_2338 var4);

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{NORTH_CONNECTION, EAST_CONNECTION, SOUTH_CONNECTION, WEST_CONNECTION, UP_CONNECTION, DOWN_CONNECTION, WATERLOGGED});
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_265 method_26159(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapes.get(state);
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 context) {
        return this.shapes.get(state);
    }
}

