/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.fluid_transport.entity;

import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class FlexTankBlockEntity
extends SyncableBlockEntity {
    private Set<class_2338> children = Sets.newHashSet();
    @Nullable
    private class_2338 root;
    private final StorageCache cache = new StorageCache();
    private final FlexTankStorage storage = new FlexTankStorage(this::method_5431);
    private final long capacity;

    public FlexTankBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, long capacity) {
        super(type, pos, state);
        this.capacity = capacity;
    }

    public static FlexTankBlockEntity updateConnections(class_1937 world, FlexTankBlockEntity origin, class_2591<FlexTankBlockEntity> type) {
        Set<FlexTankBlockEntity> found = FlexTankBlockEntity.findBlocks(world, origin.method_11016(), type);
        if (!found.isEmpty()) {
            FlexTankBlockEntity root = null;
            int lowest = Integer.MAX_VALUE;
            for (FlexTankBlockEntity be : found) {
                class_2338 bePos;
                if (root == null) {
                    root = be;
                }
                if ((bePos = be.method_11016()).method_10264() >= lowest) continue;
                lowest = bePos.method_10264();
                root = be;
            }
            root.markRoot(found.stream().map(class_2586::method_11016).collect(Collectors.toSet()));
            for (FlexTankBlockEntity be : found) {
                be.setRoot(root);
            }
            return root;
        }
        return null;
    }

    protected static Set<FlexTankBlockEntity> findBlocks(class_1937 world, class_2338 start, class_2591<FlexTankBlockEntity> type) {
        HashSet found = Sets.newHashSet();
        ArrayDeque queue = Queues.newArrayDeque();
        HashSet visited = Sets.newHashSet();
        queue.add(start);
        visited.add(start);
        world.method_35230(start, type).ifPresent(found::add);
        while (!queue.isEmpty()) {
            class_2338 current = (class_2338)queue.poll();
            class_2338.class_2339 mutable = current.method_25503();
            for (class_2350 direction : class_2350.values()) {
                mutable.method_25505((class_2382)current, direction);
                if (visited.contains(mutable)) continue;
                visited.add(mutable.method_10062());
                world.method_35230((class_2338)mutable, type).ifPresent(be -> {
                    found.add(be);
                    queue.add(mutable.method_10062());
                });
            }
        }
        return found;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.root != null) {
            nbt.method_10566("root", (class_2520)class_2512.method_10692((class_2338)this.root));
        }
        if (this.children != null) {
            class_2499 list = new class_2499();
            for (class_2338 child : this.children) {
                class_2487 c = class_2512.method_10692((class_2338)child);
                list.add((Object)c);
            }
            nbt.method_10566("children", (class_2520)list);
        }
        this.storage.writeNbt(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("root")) {
            this.root = class_2512.method_10691((class_2487)nbt.method_10562("root"));
        }
        if (nbt.method_10545("children")) {
            class_2499 list = nbt.method_10554("children", 10);
            for (int i = 0; i < list.size(); ++i) {
                this.children.add(class_2512.method_10691((class_2487)list.method_10602(i)));
            }
        }
        this.storage.readNbt(nbt);
    }

    public Storage<FluidVariant> getStorage(class_2350 direction) {
        return this.storage;
    }

    public void markRoot(Set<class_2338> children) {
        this.children = children;
        this.storage.validate();
    }

    public boolean isRoot() {
        return this.field_11867.equals((Object)this.root) || this == this.getRoot();
    }

    public void setRoot(FlexTankBlockEntity root) {
        if (root != this) {
            this.children.clear();
            if (this.storage.getAmount() != 0L) {
                try (Transaction transaction = Transaction.openOuter();){
                    FluidVariant variant = (FluidVariant)this.storage.getResource();
                    long extracted = this.storage.extract(variant, this.storage.getAmount(), (TransactionContext)transaction);
                    if (extracted > 0L) {
                        long l = root.storage.insert(variant, extracted, (TransactionContext)transaction);
                    }
                    transaction.commit();
                }
            }
        }
        this.root = root.method_11016();
    }

    @Nullable
    public FlexTankBlockEntity getRoot() {
        class_2586 class_25862;
        if (this.root != null && (class_25862 = this.field_11863.method_8321(this.root)) instanceof FlexTankBlockEntity) {
            FlexTankBlockEntity be = (FlexTankBlockEntity)class_25862;
            return be;
        }
        return null;
    }

    public int getSize() {
        if (!this.isRoot()) {
            return this.getRoot().getSize();
        }
        return this.children.size();
    }

    private class StorageCache {
        private BlockApiCache<Storage<FluidVariant>, class_2350> cache = null;
        private class_2338 lastRootPos = null;

        private StorageCache() {
        }

        public Storage<FluidVariant> find() {
            Storage found;
            if (!(Objects.equals(this.lastRootPos, FlexTankBlockEntity.this.root) && this.cache != null || FlexTankBlockEntity.this.root == null)) {
                this.lastRootPos = FlexTankBlockEntity.this.root;
                this.cache = BlockApiCache.create((BlockApiLookup)FluidStorage.SIDED, (class_3218)((class_3218)FlexTankBlockEntity.this.field_11863), (class_2338)FlexTankBlockEntity.this.root);
            }
            if (this.cache != null && (found = (Storage)this.cache.find((Object)class_2350.field_11033)) != null) {
                return found;
            }
            return Storage.empty();
        }
    }

    class FlexTankStorage
    extends WritableSingleFluidStorage {
        public FlexTankStorage(Runnable finalCallback) {
            super(0L, finalCallback);
        }

        @Override
        public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            if (FlexTankBlockEntity.this.isRoot()) {
                return super.insert(insertedVariant, maxAmount, transaction);
            }
            if (FlexTankBlockEntity.this.root != null) {
                return FlexTankBlockEntity.this.cache.find().insert((Object)insertedVariant, maxAmount, transaction);
            }
            return 0L;
        }

        public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
            if (FlexTankBlockEntity.this.isRoot()) {
                return super.extract((TransferVariant)extractedVariant, maxAmount, transaction);
            }
            if (FlexTankBlockEntity.this.root != null) {
                return FlexTankBlockEntity.this.cache.find().extract((Object)extractedVariant, maxAmount, transaction);
            }
            return 0L;
        }

        public Iterator<StorageView<FluidVariant>> iterator() {
            if (FlexTankBlockEntity.this.isRoot()) {
                return super.iterator();
            }
            if (FlexTankBlockEntity.this.root != null) {
                return FlexTankBlockEntity.this.cache.find().iterator();
            }
            return Collections.emptyIterator();
        }

        @Override
        protected long getCapacity(FluidVariant variant) {
            return (long)FlexTankBlockEntity.this.children.size() * FlexTankBlockEntity.this.capacity;
        }

        public void validate() {
            this.amount = Math.min(this.getCapacity(), this.amount);
        }
    }
}

