/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.item_transport;

import com.neep.neepmeat.transport.ItemTransport;
import com.neep.neepmeat.transport.api.item_network.RoutablePipe;
import com.neep.neepmeat.transport.api.item_network.RoutingNetwork;
import com.neep.neepmeat.transport.api.pipe.ItemPipe;
import com.neep.neepmeat.transport.block.item_transport.entity.ItemPipeBlockEntity;
import com.neep.neepmeat.transport.fluid_network.node.NodePos;
import com.neep.neepmeat.util.BFSGroupFinder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class RoutingNetworkImpl
implements RoutingNetwork {
    protected boolean needsUpdate = true;
    protected final GroupFinder finder = new GroupFinder();
    protected long version;
    protected Supplier<class_3218> worldSupplier;
    protected final class_2338 pos;
    protected final Long2ObjectMap<BlockApiCache<RoutablePipe, class_2350>> routePipeMap = new Long2ObjectOpenHashMap();
    protected final List<RoutablePipe> routePipes = new ObjectArrayList();
    protected boolean valid;

    public RoutingNetworkImpl(class_2338 pos, Supplier<class_3218> worldSupplier) {
        this.pos = pos;
        this.worldSupplier = worldSupplier;
    }

    public static <T> ResourceAmount<T> viewToAmount(StorageView<T> view) {
        return new ResourceAmount(view.getResource(), view.getAmount());
    }

    @Override
    public void invalidate() {
        this.needsUpdate = true;
        ++this.version;
    }

    @Override
    public boolean needsUpdate() {
        return this.needsUpdate;
    }

    @Override
    public void update() {
        this.needsUpdate = false;
        this.routePipeMap.clear();
        this.routePipes.clear();
        this.finder.reset();
        this.finder.queueBlock(this.pos);
        this.finder.loop(800);
        if (this.finder.controllers > 1) {
            this.valid = false;
            return;
        }
        this.finder.getResult().forEach((k, v) -> this.routePipeMap.put(k.method_10063(), v));
        this.routePipeMap.values().stream().map(c -> (RoutablePipe)c.find(null)).filter(Objects::nonNull).sorted(RoutingNetworkImpl::compare).forEachOrdered(this.routePipes::add);
        this.finder.getVisited().forEach(p -> {
            class_2586 patt3721$temp = this.worldSupplier.get().method_8321(class_2338.method_10092((long)p));
            if (patt3721$temp instanceof ItemPipeBlockEntity) {
                ItemPipeBlockEntity be = (ItemPipeBlockEntity)patt3721$temp;
                be.getCache().setNetwork(this.worldSupplier.get(), this.pos);
            }
        });
        this.valid = true;
    }

    private static int compare(RoutablePipe p0, RoutablePipe p1) {
        int x = p0.priority();
        int y = p1.priority();
        return Integer.compare(y, x);
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public List<ResourceAmount<ItemVariant>> getAllAvailable(TransactionContext transaction) {
        return (List)this.routePipes.stream().flatMap(p -> p.getAvailable(transaction)).filter(v -> !v.isResourceBlank()).map(RoutingNetworkImpl::viewToAmount).collect(Collectors.collectingAndThen(Collectors.toMap(ResourceAmount::resource, Function.identity(), RoutingNetworkImpl::combine), m -> new ObjectArrayList(m.values())));
    }

    protected static <T> ResourceAmount<T> combine(ResourceAmount<T> am1, ResourceAmount<T> am2) {
        return new ResourceAmount(am1.resource(), am1.amount() + am2.amount());
    }

    @Override
    public boolean route(Predicate<ItemVariant> predicate, long amount, class_2338 inPos, class_2350 inDir, class_2338 outPos, class_2350 outDir, RoutingNetwork.RequestType type, TransactionContext transaction) {
        amount = Math.max(0L, amount);
        try (Transaction inner = transaction.openNested();){
            long routed;
            RoutablePipe inPipe;
            BlockApiCache inPipeCache = (BlockApiCache)this.routePipeMap.get(inPos.method_10063());
            if (inPipeCache != null && (inPipe = (RoutablePipe)inPipeCache.find(null)) != null && type.satisfied(amount, routed = inPipe.request(predicate, amount, new NodePos(outPos, outDir), (TransactionContext)inner))) {
                this.worldSupplier.get().method_14199((class_2394)class_2398.field_11251, (double)this.pos.method_10263() + 0.5, (double)(this.pos.method_10264() + 1), (double)this.pos.method_10260() + 0.5, 20, 0.1, 0.0, 0.1, 0.01);
                this.worldSupplier.get().method_43128(null, (double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260(), class_3417.field_22266, class_3419.field_15245, 1.0f, 1.0f);
                inner.commit();
                boolean bl = true;
                return bl;
            }
            inner.abort();
        }
        return false;
    }

    @Override
    public boolean request(Predicate<ItemVariant> predicate, long amount, class_2338 pos, class_2350 outDir, RoutingNetwork.RequestType type, TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            AtomicLong amountRemaining = new AtomicLong(amount);
            boolean satisfied = this.routePipes.stream().anyMatch(e -> {
                long retrieved = e.request(predicate, amountRemaining.get(), new NodePos(pos, outDir), (TransactionContext)inner);
                amountRemaining.addAndGet(-retrieved);
                return amountRemaining.get() <= 0L;
            });
            if (type.satisfied(amount, amount - amountRemaining.get())) {
                this.worldSupplier.get().method_14199((class_2394)class_2398.field_11251, (double)this.pos.method_10263() + 0.5, (double)(this.pos.method_10264() + 1), (double)this.pos.method_10260() + 0.5, 20, 0.1, 0.0, 0.1, 0.01);
                this.worldSupplier.get().method_43128(null, (double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260(), class_3417.field_22266, class_3419.field_15245, 1.0f, 1.0f);
                inner.commit();
                boolean bl = satisfied;
                return bl;
            }
            inner.abort();
        }
        return false;
    }

    protected class GroupFinder
    extends BFSGroupFinder<BlockApiCache<RoutablePipe, class_2350>> {
        protected int controllers = 0;

        protected GroupFinder() {
        }

        @Override
        public void reset() {
            super.reset();
            this.controllers = 0;
        }

        public Set<Long> getVisited() {
            return this.visited;
        }

        @Override
        protected BFSGroupFinder.State processPos(class_2338 pos) {
            ItemPipe fromPipe = (ItemPipe)ItemTransport.ITEM_PIPE_LOOKUP.find((class_1937)RoutingNetworkImpl.this.worldSupplier.get(), pos, null);
            if (this.checkController(RoutingNetworkImpl.this.worldSupplier.get(), pos)) {
                return BFSGroupFinder.State.FAIL;
            }
            class_2338.class_2339 mutable = pos.method_25503();
            for (class_2350 direction : fromPipe.getConnections(RoutingNetworkImpl.this.worldSupplier.get().method_8320(pos), null)) {
                ItemPipe toPipe;
                mutable.method_25505((class_2382)pos, direction);
                RoutablePipe routablePipe = (RoutablePipe)RoutablePipe.LOOKUP.find((class_1937)RoutingNetworkImpl.this.worldSupplier.get(), (class_2338)mutable, null);
                if (routablePipe != null) {
                    this.addResult((class_2338)mutable, BlockApiCache.create(RoutablePipe.LOOKUP, (class_3218)RoutingNetworkImpl.this.worldSupplier.get(), (class_2338)mutable));
                }
                if ((toPipe = (ItemPipe)ItemTransport.ITEM_PIPE_LOOKUP.find((class_1937)RoutingNetworkImpl.this.worldSupplier.get(), (class_2338)mutable, null)) == null) continue;
                this.queueBlock((class_2338)mutable);
            }
            return BFSGroupFinder.State.CONTINUE;
        }

        protected boolean checkController(class_3218 world, class_2338 current) {
            BlockApiCache cache = BlockApiCache.create(RoutingNetwork.LOOKUP, (class_3218)world, (class_2338)current);
            if (cache.find(null) != null) {
                ++this.controllers;
            }
            return false;
        }
    }
}

