/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.item_transport.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.util.graph.PipeVertex;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.transport.api.pipe.ItemPipe;
import com.neep.neepmeat.transport.api.pipe.PipeConnections;
import com.neep.neepmeat.transport.block.item_transport.OpaqueItemPipeBlock;
import com.neep.neepmeat.transport.item_network.ItemInPipe;
import com.neep.neepmeat.transport.item_network.ItemPipeVertexImpl;
import com.neep.neepmeat.transport.item_network.RoutingNetworkCache;
import com.neep.neepmeat.transport.item_network.ShittyRoutingCallbackHolder;
import com.neep.neepmeat.transport.util.ItemPipeUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class ItemPipeBlockEntity
extends SyncableBlockEntity {
    public static int MAX_ITEMS = 300;
    protected List<ItemInPipe> items = new ArrayList<ItemInPipe>();
    protected RoutingNetworkCache cache = new RoutingNetworkCache();
    protected final List<BlockApiCache<Storage<ItemVariant>, class_2350>> storageCaches = new ObjectArrayList(Collections.nCopies(6, null));
    public int lastOutput;
    protected final ItemPipeVertexImpl vertex;
    protected final ShittyRoutingCallbackHolder callbackHolder = new ShittyRoutingCallbackHolder();

    public ItemPipeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        this(type, pos, state, ItemPipeVertexImpl::new);
    }

    public ItemPipeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, PipeConstructor<?> constructor) {
        super((class_2591<?>)(state.method_26204() instanceof OpaqueItemPipeBlock && type != NMBlockEntities.OPAQUE_ITEM_PIPE ? NMBlockEntities.OPAQUE_ITEM_PIPE : type), pos, state);
        this.vertex = constructor.create(this);
    }

    public List<ItemInPipe> getItems() {
        return this.items;
    }

    public ShittyRoutingCallbackHolder getCallbacks() {
        return this.callbackHolder;
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_2499 itemList = new class_2499();
        for (ItemInPipe offset : this.items) {
            class_2487 nbt1 = new class_2487();
            nbt1 = offset.toNbt(nbt1);
            itemList.add((Object)nbt1);
        }
        tag.method_10566("items", (class_2520)itemList);
        tag.method_10566("vertex", (class_2520)this.vertex.writeNbt(new class_2487()));
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        class_2499 itemList = (class_2499)tag.method_10580("items");
        int size = itemList != null ? itemList.size() : 0;
        this.items.clear();
        for (int i = 0; i < size; ++i) {
            this.items.add(ItemInPipe.fromNbt(itemList.method_10602(i)));
        }
        if (!tag.method_10545("vertex")) {
            this.vertex.needsMigration = true;
        }
        this.vertex.readNbt(tag.method_10562("vertex"));
    }

    public void serverTick(class_1937 world, class_2338 pos, class_2680 state) {
        int numItems = this.items.size();
        if (numItems == 0) {
            return;
        }
        ListIterator<ItemInPipe> it = this.items.listIterator();
        while (it.hasNext()) {
            ItemInPipe item = (ItemInPipe)it.next();
            item.tick();
            if (!(item.progress >= 1.0f)) continue;
            Transaction transaction = Transaction.openOuter();
            try {
                long transferred = this.pipeToAny(item, pos, item.out, world, (TransactionContext)transaction);
                if (transferred == item.amount() || item.isEmpty()) {
                    it.remove();
                } else {
                    ItemPipeUtil.bounce(item, world, state);
                }
                transaction.commit();
            }
            finally {
                if (transaction == null) continue;
                transaction.close();
            }
        }
        this.sync();
    }

    private long pipeToAny(ItemInPipe item, class_2338 pos, class_2350 out, class_1937 world, TransactionContext transaction) {
        class_2338 toPos = pos.method_10093(out);
        class_2680 toState = world.method_8320(toPos);
        class_2248 toBlock = toState.method_26204();
        long amountInserted = 0L;
        if (toBlock instanceof ItemPipe) {
            ItemPipe pipe = (ItemPipe)toBlock;
            amountInserted = ItemPipeUtil.itemToPipe(item, pipe, (class_3218)world, toPos, toState, out, transaction);
        } else if (ItemPipeUtil.canDumpInto(world, toPos, toState)) {
            amountInserted = ItemPipeUtil.itemToWorld(item, 0.2, item.speed, world, toPos, out, transaction);
        } else {
            Storage<ItemVariant> storage = this.getStorage(out);
            if (storage != null) {
                amountInserted = ItemPipeUtil.itemToStorage(item, storage, transaction);
            }
        }
        if (amountInserted != item.amount()) {
            item.decrement((int)amountInserted);
        }
        return amountInserted;
    }

    public long insert(ItemInPipe item, class_1937 world, class_2680 state, class_2338 pos, class_2350 in, TransactionContext transaction) {
        class_2350 out = ((ItemPipe)this.method_11010().method_26204()).getOutputDirection(item, pos, state, world, in, this, !this.vertex.canSimplify(), transaction);
        transaction.addCloseCallback((TransactionContext.CloseCallback)new InsertCallback(item, in, out, world, this));
        return item.amount();
    }

    protected void insertItemCallback(ItemInPipe item, class_2350 in, class_2350 out, class_1937 world) {
        if (this.items.size() < MAX_ITEMS) {
            item.reset(in, out, world.method_8510());
            this.items.add(item);
        }
    }

    public void dropItems() {
        for (ItemInPipe item : this.items) {
            class_1542 itemEntity = new class_1542(this.method_10997(), (double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5, item.toItemStack());
            item.zero();
            this.method_10997().method_8649((class_1297)itemEntity);
        }
        this.items.clear();
    }

    public RoutingNetworkCache getCache() {
        return this.cache;
    }

    public BlockApiCache<Storage<ItemVariant>, class_2350> getStorageCache(class_2350 localDirection) {
        int id = localDirection.ordinal();
        if (this.storageCaches.get(id) == null) {
            this.storageCaches.set(id, (BlockApiCache<Storage<ItemVariant>, class_2350>)BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)((class_3218)this.field_11863), (class_2338)this.field_11867.method_10093(localDirection)));
        }
        return this.storageCaches.get(id);
    }

    @Nullable
    public Storage<ItemVariant> getStorage(class_2350 localDirection) {
        return (Storage)this.getStorageCache(localDirection).find((Object)localDirection.method_10153());
    }

    public int getCurrentOutput(PipeConnections connections) {
        if (!connections.contains(class_2350.values()[this.lastOutput])) {
            return this.nextOutput(connections);
        }
        return this.lastOutput;
    }

    public int nextOutput(PipeConnections connections) {
        this.lastOutput = (this.lastOutput + 1) % 6;
        int i = 0;
        while (!connections.contains(class_2350.values()[this.lastOutput])) {
            this.lastOutput = (this.lastOutput + 1) % 6;
            if (i >= 6) {
                return 0;
            }
            ++i;
        }
        return this.lastOutput;
    }

    public PipeVertex getVertex() {
        return this.vertex;
    }

    @FunctionalInterface
    public static interface PipeConstructor<T extends ItemPipeVertexImpl> {
        public T create(ItemPipeBlockEntity var1);
    }

    private record InsertCallback(ItemInPipe item, class_2350 in, class_2350 out, class_1937 world, ItemPipeBlockEntity be) implements TransactionContext.CloseCallback
    {
        public void onClose(TransactionContext transaction, TransactionContext.Result result) {
            if (result.wasCommitted()) {
                if (transaction.nestingDepth() > 0) {
                    transaction.getOpenTransaction(transaction.nestingDepth() - 1).addCloseCallback((TransactionContext.CloseCallback)this);
                } else {
                    transaction.addOuterCloseCallback(r -> {
                        if (!r.wasCommitted()) {
                            return;
                        }
                        this.be.insertItemCallback(this.item, this.in, this.out, this.world);
                    });
                }
            }
        }
    }
}

