/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.item_transport.machine;

import com.neep.meatlib.block.BaseFacingBlock;
import com.neep.meatlib.storage.MeatlibStorageUtil;
import com.neep.meatlib.storage.ResourcePredicate;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.transport.api.pipe.ItemPipe;
import com.neep.neepmeat.transport.block.item_transport.machine.EjectorBlockEntity;
import com.neep.neepmeat.transport.block.item_transport.machine.ItemPumpBlock;
import com.neep.neepmeat.transport.interfaces.IServerWorld;
import com.neep.neepmeat.transport.item_network.RetrievalTarget;
import com.neep.neepmeat.transport.item_network.ShittyRoutingListener;
import com.neep.neepmeat.transport.util.ItemPipeUtil;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;

public class ItemPumpBlockEntity
extends EjectorBlockEntity
implements ShittyRoutingListener {
    protected List<RetrievalTarget<ItemVariant>> retrievalCache = null;

    public ItemPumpBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public ItemPumpBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.ITEM_PUMP, pos, state);
    }

    @Override
    public void serverTick() {
        if (this.retrievalCache == null) {
            class_2350 face = ((class_2350)this.method_11010().method_11654((class_2769)ItemPumpBlock.field_10927)).method_10153();
            this.updateRetrievalCache((class_3218)this.field_11863, this.field_11867, face, this);
        }
        super.serverTick();
    }

    @Override
    protected void tryTransfer() {
        class_2680 state = this.method_11010();
        class_2350 facing = (class_2350)state.method_11654((class_2769)BaseFacingBlock.field_10927);
        Storage storage = (Storage)ItemStorage.SIDED.find(this.field_11863, this.field_11867.method_10093(facing.method_10153()), (Object)facing);
        if (storage != null) {
            try (Transaction transaction = Transaction.openOuter();){
                ResourceAmount<ItemVariant> extracted;
                Storage facingStorage = (Storage)this.insertionCache.find();
                long canInsert = 16L;
                ResourcePredicate<ItemVariant> predicate = (v, a) -> a;
                if (facingStorage != null) {
                    predicate = (v, a) -> MeatlibStorageUtil.simulateInsert(facingStorage, v, a, (TransactionContext)transaction);
                }
                if ((extracted = MeatlibStorageUtil.findAndExtractContent(storage, canInsert, (TransactionContext)transaction, predicate)) == null || extracted.amount() <= 0L) {
                    transaction.abort();
                    return;
                }
                this.stored = new ResourceAmount((Object)((ItemVariant)extracted.resource()), extracted.amount());
                this.succeed();
                transaction.commit();
            }
        } else {
            class_2248 transaction = this.field_11863.method_8320(this.field_11867.method_10093(facing.method_10153())).method_26204();
            if (transaction instanceof ItemPipe) {
                ItemPipe pipe = (ItemPipe)transaction;
                transaction = Transaction.openOuter();
                if (this.retrieve((Transaction)transaction)) {
                    this.succeed();
                    transaction.commit();
                } else {
                    transaction.abort();
                }
            }
        }
    }

    public boolean retrieve(Transaction transaction) {
        if (this.retrievalCache == null) {
            return false;
        }
        boolean success = false;
        Storage facingStorage = (Storage)this.insertionCache.find();
        for (RetrievalTarget<ItemVariant> target : this.retrievalCache) {
            ResourceAmount extractable;
            Storage<ItemVariant> targetStorage = target.find();
            Transaction nested1 = transaction.openNested();
            if (facingStorage != null) {
                Transaction nested2 = nested1.openNested();
                extractable = MeatlibStorageUtil.findExtractableContent(targetStorage, (t, itemVariant) -> MeatlibStorageUtil.simulateInsert(facingStorage, itemVariant, Long.MAX_VALUE, t) > 0L, (TransactionContext)nested2);
                nested2.abort();
            } else {
                extractable = StorageUtil.findExtractableContent(targetStorage, (TransactionContext)nested1);
            }
            if (extractable == null) {
                nested1.abort();
                continue;
            }
            long transferable = this.canForward(extractable, nested1);
            if (transferable < 1L) {
                nested1.abort();
                continue;
            }
            long extracted = targetStorage.extract((Object)((ItemVariant)extractable.resource()), Math.min(transferable, 16L), (TransactionContext)nested1);
            long forwarded = this.forwardRetrieval((ResourceAmount<ItemVariant>)new ResourceAmount((Object)((ItemVariant)(extractable = new ResourceAmount((Object)((ItemVariant)extractable.resource()), extracted)).resource()), extracted), target, (TransactionContext)nested1);
            if (forwarded < 1L) {
                nested1.abort();
                continue;
            }
            nested1.commit();
            success = true;
        }
        return success;
    }

    public long forwardRetrieval(ResourceAmount<ItemVariant> amount, RetrievalTarget<ItemVariant> target, TransactionContext transaction) {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)ItemPumpBlock.field_10927);
        return ((IServerWorld)this.field_11863).getItemNetwork().route(target.getPos(), target.accessFace(), this.field_11867.method_10093(facing.method_10153()), facing, (ItemVariant)amount.resource(), (int)amount.amount(), transaction);
    }

    private void updateRetrievalCache(class_3218 world, class_2338 pos, class_2350 face, ItemPumpBlockEntity be) {
        this.retrievalCache = ItemPipeUtil.floodSearch(this, pos, face, (class_1937)world, 16);
    }

    public long canForward(ResourceAmount<ItemVariant> amount, Transaction transaction) {
        Storage storage;
        if (this.insertionCache != null && (storage = (Storage)this.insertionCache.find()) != null) {
            return MeatlibStorageUtil.simulateInsert(storage, (ItemVariant)amount.resource(), amount.amount(), (TransactionContext)transaction);
        }
        return amount.amount();
    }

    @Override
    public void invalidate() {
        this.retrievalCache = null;
    }
}

