/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.client.screen.filter;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatlib.client.screen.TooltipHelper;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.client.screen.NMTextField;
import com.neep.neepmeat.item.filter.FilterList;
import com.neep.neepmeat.item.filter.TagFilter;
import com.neep.neepmeat.transport.client.screen.filter.FilterEntryWidget;
import com.neep.neepmeat.transport.screen.FilterWidgetHandler;
import com.neep.neepmeat.util.TagSuggestions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class TagFilterWidget
extends FilterEntryWidget<TagFilter> {
    private final TooltipHelper belowTooltip;

    public TagFilterWidget(int w, int index, FilterList.Entry entry, TagFilter filter, FilterWidgetHandler handler) {
        super(w, 32, index, (class_2561)NeepMeat.translationKey("screen", "filter.tag_filter"), entry, filter, handler);
        this.belowTooltip = new TooltipHelper(false, PLCCols.TEXT.col, false);
    }

    @Override
    public void init() {
        super.init();
        class_327 class_3272 = class_310.method_1551().field_1772;
        int n = this.x() + 2;
        int n2 = this.y();
        Objects.requireNonNull(this.textRenderer);
        this.addDrawableChild(new TagTextField(class_3272, n, n2 + 9 + 4, this.w - 4, 16, this::update, ((TagFilter)this.filter).getTag() != null ? ((TagFilter)this.filter).getTag().comp_327().toString() : ""));
    }

    private void update(String text) {
        class_2960 id = class_2960.method_12829((String)text);
        if (TagSuggestions.INSTANCE.isValid(id)) {
            ((TagFilter)this.filter).setTag((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)id));
            this.handler.updateToServer.emitter().apply(this.index, ((TagFilter)this.filter).writeNbt(new class_2487()));
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean b = super.method_25402(mouseX, mouseY, button);
        return b;
    }

    private class TagTextField
    extends NMTextField {
        private final Consumer<String> update;
        private List<class_2960> suggestions;

        public TagTextField(class_327 textRenderer, int x, int y, int width, int height, Consumer<String> update, String initial) {
            super(textRenderer, x, y, width, height, (class_2561)class_2561.method_43473());
            this.suggestions = List.of();
            this.update = update;
            this.setText(initial);
            this.setChangedListener(this::onChanged);
        }

        @Override
        public void onClick(double mouseX, double mouseY) {
            super.onClick(mouseX, mouseY);
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            return super.method_25402(mouseX, mouseY, button);
        }

        @Override
        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (((TagFilterWidget)TagFilterWidget.this).client.field_1690.field_1822.method_1417(keyCode, scanCode)) {
                return true;
            }
            if (keyCode == 258) {
                this.cycleSuggestion(class_437.method_25442() ? 1 : -1);
                return true;
            }
            if (keyCode == 257) {
                this.confirmSuggestion();
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        @Override
        public boolean method_25400(char chr, int modifiers) {
            return super.method_25400(chr, modifiers);
        }

        @Override
        protected void renderBackground(class_332 context, int mouseX, int mouseY, float delta) {
            int borderCol = this.isSelected() ? PLCCols.SELECTED.col : PLCCols.BORDER.col;
            GUIUtil.renderBorderInner(context, this.x(), this.y(), this.w(), this.h(), borderCol, 0);
        }

        @Override
        public void renderButton(class_332 context, int mouseX, int mouseY, float delta) {
            super.renderButton(context, mouseX, mouseY, delta);
            int maxSuggestions = 5;
            if (!this.suggestions.isEmpty() && this.isActive()) {
                int suggestionY = this.y2();
                int end = Math.min(this.suggestions.size(), maxSuggestions);
                Objects.requireNonNull(this.textRenderer);
                int stride = 9 + 2;
                List<class_2561> texts = this.suggestions.stream().limit(maxSuggestions).map(i -> class_2561.method_30163((String)i.toString())).toList();
                TagFilterWidget.this.belowTooltip.draw(context, this.x(), suggestionY, texts);
            }
        }

        @Override
        protected int renderUnselectedText(class_332 context, String string, boolean selectionWithin, int textStart, int m, int col, int j) {
            if (!this.suggestions.isEmpty()) {
                GUIUtil.drawText(context, this.textRenderer, this.suggestions.get(0).toString(), (float)textStart, (float)m, PLCCols.INVALID.col, true);
            }
            return super.renderUnselectedText(context, string, selectionWithin, textStart, m, col, j);
        }

        @Override
        public String getPrefix() {
            return "#";
        }

        private void onChanged(String current) {
            this.suggestions = TagSuggestions.INSTANCE.get(current);
            this.update.accept(current);
        }

        private void cycleSuggestion(int distance) {
            Collections.rotate(this.suggestions, distance);
        }

        private void confirmSuggestion() {
            if (!this.suggestions.isEmpty()) {
                this.setText(this.suggestions.get(0).toString());
            }
        }

        @Override
        protected int prefixCol() {
            return PLCCols.LINE_NUMBER.col;
        }

        @Override
        public void method_25365(boolean focused) {
            super.method_25365(focused);
        }
    }
}

