/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.item_network;

import com.neep.neepmeat.transport.api.pipe.ItemPipe;
import com.neep.neepmeat.transport.api.pipe.PipeConnections;
import com.neep.neepmeat.transport.block.item_transport.machine.PipeItemMemory;
import com.neep.neepmeat.transport.item_network.ItemRoute;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2479;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class ItemInPipe {
    public double x;
    public double y;
    public double z;
    public class_2350 in;
    public class_2350 out;
    public float progress;
    public int pipeTicks;
    public long tickStart;
    public long tickEnd;
    public float speed;
    protected ItemVariant variant;
    protected int amount;
    protected ItemRoute route = ItemRoute.EMPTY;
    @Nullable
    public PipeItemMemory callback;

    public ItemInPipe(ResourceAmount<ItemVariant> amount, long tickStart) {
        this(null, null, (ItemVariant)amount.resource(), (int)amount.amount(), tickStart);
    }

    public ItemInPipe(ItemVariant variant, int amount) {
        this(null, null, variant, amount, 0L);
    }

    public ItemInPipe(class_2350 in, class_2350 out, ItemVariant variant, int amount, long tickStart) {
        this.in = in;
        this.out = out;
        this.progress = 0.0f;
        this.variant = variant;
        this.amount = amount;
        this.speed = 0.1f;
        this.tickStart = tickStart;
        this.tickEnd = (long)((float)tickStart + 1.0f / this.speed);
    }

    public ItemVariant resource() {
        return this.variant;
    }

    public long amount() {
        return Math.max(this.amount, 0);
    }

    public void setRoute(ItemRoute route) {
        this.route = route;
    }

    public class_2350 getPreferredOutputDirection(class_2680 state, class_2350 in, ItemPipe pipe, boolean nonTrivial) {
        PipeConnections options = pipe.getConnections(state, in);
        if (this.route != null && !this.route.isEmpty() && (options.size() > 1 || nonTrivial)) {
            return (class_2350)this.route.remove(0);
        }
        return null;
    }

    public static class_243 directionUnit(class_2350 direction) {
        return new class_243((double)direction.method_10148(), (double)direction.method_10164(), (double)direction.method_10165());
    }

    public class_1799 toItemStack() {
        return this.variant.toStack(this.amount);
    }

    public void set(class_243 vec) {
        this.x = vec.field_1352;
        this.y = vec.field_1351;
        this.z = vec.field_1350;
    }

    public void tick() {
        ++this.pipeTicks;
        this.progress = (float)this.pipeTicks * this.speed;
    }

    public class_243 getPosition(float prog) {
        float inFactor = 1.0f - prog;
        class_243 vec = (double)prog <= 0.5 ? ItemInPipe.directionUnit(this.in).method_1021((double)inFactor - 0.5) : ItemInPipe.directionUnit(this.out).method_1021((double)prog - 0.5);
        return vec;
    }

    public void reset(class_2350 in, class_2350 out, long tickStart) {
        this.progress = 0.0f;
        this.pipeTicks = 0;
        this.in = in;
        this.out = out;
        this.tickStart = tickStart;
        this.tickEnd = (long)((float)tickStart + 1.0f / this.speed);
        this.set(new class_243(0.0, 0.0, 0.0));
    }

    public ResourceAmount<ItemVariant> toResourceAmount() {
        ResourceAmount itemVariantResourceAmount = new ResourceAmount((Object)this.variant, (long)this.amount);
        if (((ItemVariant)itemVariantResourceAmount.resource()).isBlank()) {
            itemVariantResourceAmount = new ResourceAmount((Object)ItemVariant.of((class_1799)class_1802.field_20391.method_7854()), 1L);
        }
        return itemVariantResourceAmount;
    }

    public void decrement(int i) {
        if (this.amount - i >= 0 && this.callback != null) {
            this.callback.tickOff(this.variant, i);
        }
        this.amount -= i;
    }

    public void zero() {
        if (this.amount > 0 && this.callback != null) {
            this.callback.tickOff(this.variant, this.amount);
        }
        this.amount = 0;
    }

    private static byte[] writeRoute(List<class_2350> route) {
        byte[] bytes = new byte[route.size()];
        for (int i = 0; i < route.size(); ++i) {
            bytes[i] = (byte)route.get(i).method_10146();
        }
        return bytes;
    }

    private static ItemRoute readRoute(class_2479 byteArray) {
        if (byteArray == null) {
            return ItemRoute.EMPTY;
        }
        return ItemRoute.fromByteArray(byteArray);
    }

    public class_2487 toNbt(class_2487 nbt) {
        nbt.method_10569("in", this.in.method_10146());
        nbt.method_10569("out", this.out.method_10146());
        nbt.method_10544("tick_start", this.tickStart);
        nbt.method_10544("tick_end", this.tickEnd);
        nbt.method_10548("speed", this.speed);
        class_2487 item = new class_2487();
        nbt.method_10566("variant", (class_2520)this.variant.toNbt());
        nbt.method_10569("amount", this.amount);
        nbt.method_10566("item", (class_2520)item);
        if (this.route != null) {
            nbt.method_10570("route", ItemInPipe.writeRoute((List<class_2350>)((Object)this.route)));
        }
        return nbt;
    }

    public static ItemInPipe fromNbt(class_2487 nbt) {
        class_2350 in = class_2350.method_10143((int)nbt.method_10550("in"));
        class_2350 out = class_2350.method_10143((int)nbt.method_10550("out"));
        ItemVariant variant = ItemVariant.fromNbt((class_2487)nbt.method_10562("variant"));
        int amount = nbt.method_10550("amount");
        long tickStart = nbt.method_10537("tick_start");
        ItemRoute route = ItemInPipe.readRoute((class_2479)nbt.method_10580("route"));
        float speed = nbt.method_10583("speed");
        ItemInPipe item = new ItemInPipe(in, out, variant, amount, tickStart);
        item.setRoute(route);
        item.speed = speed;
        return item;
    }

    public ItemInPipe split(int amount) {
        ItemInPipe newItem = new ItemInPipe(this.in, this.out, this.variant, amount, this.tickStart);
        newItem.x = this.x;
        newItem.y = this.y;
        newItem.z = this.z;
        newItem.speed = this.speed;
        newItem.tickEnd = this.tickEnd;
        newItem.pipeTicks = this.pipeTicks;
        newItem.route = new ItemRoute(this.route);
        newItem.callback = this.callback;
        return newItem;
    }

    public boolean isEmpty() {
        return this.amount == 0 || this.variant.isBlank();
    }
}

