/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.util;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public abstract class DFSFinder<T> {
    private final Deque<class_2338> posStack = new ArrayDeque<class_2338>();
    private final Deque<class_2350> dirStack = new ArrayDeque<class_2350>();
    private final Set<Long> visited = new LongOpenHashSet();
    private Pair<class_2338, T> result;
    private State state;

    protected void setResult(class_2338 pos, T result) {
        this.result = Pair.of((Object)pos.method_10062(), result);
    }

    public Pair<class_2338, T> getResult() {
        return this.result;
    }

    protected boolean visited(class_2338 pos) {
        return this.visited.contains(pos.method_10063());
    }

    protected void setVisited(class_2338 pos) {
        this.visited.add(pos.method_10063());
    }

    public void reset() {
        this.posStack.clear();
        this.dirStack.clear();
        this.visited.clear();
        this.result = null;
    }

    public void pushBlock(class_2338 pos, class_2350 direction) {
        this.posStack.push(pos.method_10062());
        this.dirStack.push(direction);
    }

    public class_2338 popBlock() {
        return this.posStack.pop();
    }

    public class_2350 popDir() {
        return this.dirStack.pop();
    }

    public void prepare(class_2338 start, class_2350 startDir) {
        this.pushBlock(start, startDir);
    }

    public void loop(int maxDepth) {
        for (int depth = 0; depth < maxDepth && this.propagate(); ++depth) {
        }
    }

    public boolean propagate() {
        if (!this.posStack.isEmpty()) {
            this.state = this.processPos(this.posStack.peek(), this.dirStack.peek());
            return this.state == State.CONTINUE;
        }
        return false;
    }

    protected abstract State processPos(class_2338 var1, class_2350 var2);

    public boolean hasResult() {
        return this.result != null;
    }

    public static enum State {
        CONTINUE,
        REVERSE,
        FAIL,
        SUCCESS;

    }
}

