/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.util;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;

public final class Completions {
    public static <T> CompletionStage<T> supplyAsync(Callable<T> callable, Executor executor) {
        return CompletableFuture.supplyAsync(() -> Completions.wrapExceptions(callable), executor);
    }

    public static <T> T wrapExceptions(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (CompletionException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw new CompletionException(e.getCause());
        }
        catch (Throwable e) {
            throw new CompletionException(e);
        }
    }

    public static <T, R> Function<T, R> checkedFunction(ExceptionFunction<T, R> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (CompletionException e) {
                throw e;
            }
            catch (ExecutionException e) {
                throw new CompletionException(e.getCause());
            }
            catch (Throwable e) {
                throw new CompletionException(e);
            }
        };
    }

    public static <T> CompletionStage<T> supplyAsync(Callable<T> callable) {
        return CompletableFuture.supplyAsync(() -> Completions.wrapExceptions(callable));
    }

    private Completions() {
    }

    public static interface ExceptionFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

